/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui;

import forestry.api.genetics.IBreedingTracker;
import forestry.api.genetics.capability.IIndividualHandlerItem;
import forestry.core.features.CoreItems;
import forestry.core.gui.ContainerForestry;
import forestry.core.gui.slots.SlotAnalyzer;
import forestry.core.gui.slots.SlotLockable;
import forestry.core.inventory.ItemInventoryAlyzer;
import forestry.core.utils.GeneticsUtil;
import javax.annotation.Nullable;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelAccessor;

public class ContainerAnalyzerProviderHelper {
    private static final int SLOT_ENERGY = 0;
    private final Player player;
    private final ContainerForestry container;
    @Nullable
    private final ItemInventoryAlyzer alyzerInventory;

    public ContainerAnalyzerProviderHelper(ContainerForestry container, Inventory playerInventory) {
        this.player = playerInventory.f_35978_;
        this.container = container;
        ItemInventoryAlyzer alyzerInventory = null;
        for (int i = 0; i < playerInventory.m_6643_(); ++i) {
            ItemStack stack = playerInventory.m_8020_(i);
            if (stack.m_41619_() || !CoreItems.PORTABLE_ALYZER.itemEqual(stack)) continue;
            alyzerInventory = new ItemInventoryAlyzer(playerInventory.f_35978_, stack);
            Slot slot = container.m_38853_(i < 9 ? i + 27 : i - 9);
            if (!(slot instanceof SlotLockable)) break;
            SlotLockable lockable = (SlotLockable)slot;
            lockable.lock();
            break;
        }
        this.alyzerInventory = alyzerInventory;
        if (alyzerInventory != null) {
            container.m_38897_(new SlotAnalyzer(alyzerInventory, 0, -110, 20));
        }
    }

    @Nullable
    public Slot getAnalyzerSlot() {
        if (this.alyzerInventory == null) {
            return null;
        }
        for (Slot slot : this.container.f_38839_) {
            if (!(slot instanceof SlotAnalyzer)) continue;
            return slot;
        }
        return null;
    }

    public void analyzeSpecimen(int selectedSlot) {
        if (selectedSlot < 0 || this.alyzerInventory == null) {
            return;
        }
        Slot specimenSlot = this.container.getForestrySlot(selectedSlot);
        ItemStack specimen = specimenSlot.m_7993_();
        if (specimen.m_41619_()) {
            return;
        }
        ItemStack convertedSpecimen = GeneticsUtil.convertToGeneticEquivalent(specimen);
        if (!ItemStack.m_41728_((ItemStack)specimen, (ItemStack)convertedSpecimen)) {
            specimenSlot.m_5852_(convertedSpecimen);
            specimen = convertedSpecimen;
        }
        ItemStack finalSpecimen = specimen;
        IIndividualHandlerItem.ifPresent(specimen, individual -> {
            if (!individual.isAnalyzed()) {
                ItemStack energyStack = this.alyzerInventory.m_8020_(0);
                if (!ItemInventoryAlyzer.isAlyzingFuel(energyStack)) {
                    return;
                }
                if (individual.analyze()) {
                    IBreedingTracker breedingTracker = individual.getType().getBreedingTracker((LevelAccessor)this.player.f_19853_, this.player.m_36316_());
                    breedingTracker.registerSpecies(individual.getSpecies());
                    individual.saveToStack(finalSpecimen);
                    this.alyzerInventory.m_7407_(0, 1);
                }
            }
        });
    }
}

