/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui;

import forestry.api.modules.IForestryPacketClient;
import forestry.core.gui.slots.SlotForestry;
import forestry.core.gui.slots.SlotLocked;
import forestry.core.utils.NetworkUtil;
import forestry.core.utils.SlotUtil;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public abstract class ContainerForestry
extends AbstractContainerMenu {
    public static final int PLAYER_HOTBAR_OFFSET = 27;
    public static final int PLAYER_INV_SLOTS = 36;
    private int transferCount = 0;
    @Nullable
    protected final ServerPlayer player;

    protected ContainerForestry(int containerId, MenuType<?> type, @Nullable Player player) {
        super(type, containerId);
        ServerPlayer serverPlayer;
        this.player = player instanceof ServerPlayer ? (serverPlayer = (ServerPlayer)player) : null;
    }

    protected final void addPlayerInventory(Inventory playerInventory, int xInv, int yInv) {
        for (int row = 0; row < 3; ++row) {
            for (int column = 0; column < 9; ++column) {
                this.addSlot(playerInventory, column + row * 9 + 9, xInv + column * 18, yInv + row * 18);
            }
        }
        for (int column = 0; column < 9; ++column) {
            this.addHotbarSlot(playerInventory, column, xInv + column * 18, yInv + 58);
        }
    }

    protected void addHotbarSlot(Inventory playerInventory, int slot, int x, int y) {
        super.m_38897_(new Slot((Container)playerInventory, slot, x, y));
    }

    protected void addSlot(Inventory playerInventory, int slot, int x, int y) {
        super.m_38897_(new Slot((Container)playerInventory, slot, x, y));
    }

    public Slot m_38897_(Slot slot) {
        return super.m_38897_(slot);
    }

    public void m_150399_(int slotId, int dragType_or_button, ClickType clickTypeIn, Player player) {
        SlotForestry slotForestry;
        Slot slot;
        int hotbarSlotIndex;
        Slot hotbarSlot;
        if (!this.canAccess(player)) {
            return;
        }
        if (clickTypeIn == ClickType.SWAP && dragType_or_button >= 0 && dragType_or_button < 9 && (hotbarSlot = this.m_38853_(hotbarSlotIndex = 27 + dragType_or_button)) instanceof SlotLocked) {
            return;
        }
        Slot slot2 = slot = slotId < 0 ? null : this.m_38853_(slotId);
        if (slot instanceof SlotForestry && (slotForestry = (SlotForestry)slot).isPhantom()) {
            SlotUtil.slotClickPhantom(slotForestry, dragType_or_button, clickTypeIn, player);
            return;
        }
        this.transferCount = 0;
        super.m_150399_(slotId, dragType_or_button, clickTypeIn, player);
    }

    public Slot getForestrySlot(int slot) {
        return this.m_38853_(36 + slot);
    }

    public final ItemStack m_7648_(Player player, int slotIndex) {
        if (!this.canAccess(player)) {
            return ItemStack.f_41583_;
        }
        if (this.transferCount < 64) {
            ++this.transferCount;
            return SlotUtil.transferStackInSlot((List<Slot>)this.f_38839_, player, slotIndex);
        }
        return ItemStack.f_41583_;
    }

    protected abstract boolean canAccess(Player var1);

    protected final void sendPacketToListeners(IForestryPacketClient packet) {
        if (this.player != null) {
            NetworkUtil.sendToPlayer(packet, this.player);
        }
    }
}

