/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import forestry.api.genetics.gatgets.IGeneticAnalyzer;
import forestry.api.genetics.gatgets.IGeneticAnalyzerProvider;
import forestry.core.gui.Drawable;
import forestry.core.gui.GuiForestryTitled;
import forestry.core.gui.IContainerAnalyzerProvider;
import forestry.core.gui.buttons.GuiToggleButton;
import forestry.core.gui.elements.GeneticAnalyzer;
import forestry.core.gui.elements.GuiElement;
import forestry.core.gui.elements.GuiElementFactory;
import forestry.core.gui.slots.SlotAnalyzer;
import forestry.core.inventory.ItemInventoryAlyzer;
import forestry.core.inventory.watchers.ISlotChangeWatcher;
import forestry.core.tiles.ITitled;
import javax.annotation.Nullable;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;

public abstract class GuiAnalyzerProvider<C extends AbstractContainerMenu>
extends GuiForestryTitled<C>
implements IGeneticAnalyzerProvider,
ISlotChangeWatcher {
    protected static final Drawable SELECTED_COMB_SLOT = new Drawable(GeneticAnalyzer.TEXTURE, 163, 0, 22, 22);
    protected static final Drawable TOGGLE_BUTTON = new Drawable(GeneticAnalyzer.TEXTURE, 35, 166, 18, 20);
    private static boolean analyzerVisible = false;
    public final IGeneticAnalyzer analyzer;
    @Nullable
    private SlotAnalyzer slotAnalyzer;
    private final int buttonX;
    private final int buttonY;
    private final int screenDistance;
    private final int slots;
    private final int firstSlot;
    protected boolean deactivated;
    private boolean dirtyAnalyzer = false;
    private boolean dirty = true;
    private boolean slotDirty;

    public GuiAnalyzerProvider(String texture, C container, Inventory inv, ITitled titled, int buttonX, int buttonY, int slots, int firstSlot) {
        this(texture, container, inv, titled, buttonX, buttonY, 0, false, slots, firstSlot);
    }

    public GuiAnalyzerProvider(String texture, C container, Inventory inv, ITitled titled, int buttonX, int buttonY, int screenDistance, boolean hasBorder, int slots, int firstSlot) {
        super(texture, container, inv, titled.getTitle());
        this.buttonX = buttonX;
        this.buttonY = buttonY;
        this.screenDistance = screenDistance;
        this.slots = slots;
        this.firstSlot = firstSlot;
        this.analyzer = GuiElementFactory.INSTANCE.createAnalyzer(this.window, -189 - screenDistance, 0, hasBorder, this);
        this.updateVisibility();
        Slot slot = ((IContainerAnalyzerProvider)container).getAnalyzerSlot();
        if (slot instanceof SlotAnalyzer) {
            SlotAnalyzer analyzerSlot = (SlotAnalyzer)slot;
            analyzerSlot.setVisibleCallback(this.analyzer::isVisible);
            this.slotAnalyzer = analyzerSlot;
        }
        this.slotDirty = true;
    }

    protected boolean hasErrors() {
        return false;
    }

    private void updateVisibility() {
        this.analyzer.setVisible(!this.deactivated && analyzerVisible);
    }

    protected abstract void drawSelectedSlot(PoseStack var1, int var2);

    @Override
    public void m_7856_() {
        super.m_7856_();
        if (this.analyzer.isVisible()) {
            this.f_97735_ = (this.f_96543_ - this.f_97726_ + ((GuiElement)((Object)this.analyzer)).getWidth() + this.screenDistance) / 2;
        }
        this.window.init(this.f_97735_, this.f_97736_ + (this.f_97727_ - 166) / 2);
        ((GuiToggleButton)this.m_142416_((GuiEventListener)new GuiToggleButton((int)(this.f_97735_ + this.buttonX), (int)(this.f_97736_ + this.buttonY), (int)18, (int)20, (Drawable)GuiAnalyzerProvider.TOGGLE_BUTTON, (Button.OnPress)(GuiAnalyzerProvider)this.new Handler()))).f_93624_ = ((IContainerAnalyzerProvider)this.f_97732_).getAnalyzerSlot() != null;
        this.dirty = true;
        this.slotDirty = true;
    }

    @Override
    public void m_6305_(PoseStack transform, int mouseX, int mouseY, float partialTicks) {
        boolean ledger = this.hasErrors();
        if (!this.deactivated && ledger || !ledger && this.deactivated) {
            this.deactivated = ledger;
            this.updateVisibility();
            this.dirtyAnalyzer = true;
        }
        if (this.dirtyAnalyzer) {
            this.f_169369_.clear();
            this.m_7856_();
            this.dirtyAnalyzer = false;
        }
        if (this.dirty) {
            this.analyzer.update();
            this.dirty = false;
        }
        super.m_6305_(transform, mouseX, mouseY, partialTicks);
        if (this.slotDirty) {
            if (this.slotAnalyzer != null) {
                GuiElement element = this.analyzer.getItemElement();
                int index = this.slotAnalyzer.f_40219_;
                this.slotAnalyzer = new SlotAnalyzer((ItemInventoryAlyzer)this.slotAnalyzer.f_40218_, this.slotAnalyzer.getSlotIndex(), element.getAbsoluteX() - this.f_97735_ + 6, element.getAbsoluteY() - this.f_97736_ + 9);
                this.slotAnalyzer.f_40219_ = index;
                this.slotAnalyzer.setVisibleCallback(this.analyzer::isVisible);
                this.f_97732_.f_38839_.set(index, (Object)this.slotAnalyzer);
            }
            this.slotDirty = false;
        }
    }

    @Override
    protected void m_7286_(PoseStack transform, float partialTicks, int mouseX, int mouseY) {
        int selectedSlot;
        super.m_7286_(transform, partialTicks, mouseX, mouseY);
        if (this.analyzer.isVisible() && (selectedSlot = this.analyzer.getSelected()) >= 0) {
            this.drawSelectedSlot(transform, selectedSlot);
        }
    }

    @Override
    public void onSlotChanged(Container inventory, int slot) {
        if (slot == this.analyzer.getSelected()) {
            this.dirty = true;
        }
    }

    @Override
    public int getSelectedSlot(int index) {
        return 1 + index;
    }

    @Override
    public int getSlotCount() {
        return this.slots;
    }

    @Override
    public int getFirstSlot() {
        return this.firstSlot;
    }

    private static void setAnalyzerVisible(boolean analyzerVisible) {
        GuiAnalyzerProvider.analyzerVisible = analyzerVisible;
    }

    private static boolean isAnalyzerVisible() {
        return analyzerVisible;
    }

    class Handler
    implements Button.OnPress {
        Handler() {
        }

        public void m_93750_(Button button) {
            if (button instanceof GuiToggleButton) {
                GuiAnalyzerProvider.setAnalyzerVisible(!GuiAnalyzerProvider.isAnalyzerVisible());
                GuiAnalyzerProvider.this.updateVisibility();
                GuiAnalyzerProvider.this.dirtyAnalyzer = true;
            }
        }
    }
}

