/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import forestry.core.gui.ContainerEscritoire;
import forestry.core.gui.GuiForestry;
import forestry.core.gui.GuiUtil;
import forestry.core.gui.widgets.GameTokenWidget;
import forestry.core.gui.widgets.ProbeButton;
import forestry.core.render.ColourProperties;
import forestry.core.tiles.EscritoireGame;
import forestry.core.tiles.EscritoireTextSource;
import forestry.core.tiles.TileEscritoire;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class GuiEscritoire
extends GuiForestry<ContainerEscritoire> {
    private final ItemStack LEVEL_ITEM = new ItemStack((ItemLike)Items.f_42516_);
    private final EscritoireTextSource textSource = new EscritoireTextSource();
    private final TileEscritoire tile;

    public GuiEscritoire(ContainerEscritoire container, Inventory inv, Component title) {
        super("textures/gui/escritoire.png", container, inv, title);
        this.tile = (TileEscritoire)container.getTile();
        this.f_97726_ = 228;
        this.f_97727_ = 235;
        this.widgetManager.add(new ProbeButton(this, this.widgetManager, 14, 16));
        EscritoireGame game = this.tile.getGame();
        this.addTokenWidget(game, 115, 51, 0);
        this.addTokenWidget(game, 115, 77, 1);
        this.addTokenWidget(game, 94, 90, 2);
        this.addTokenWidget(game, 73, 77, 3);
        this.addTokenWidget(game, 73, 51, 4);
        this.addTokenWidget(game, 94, 38, 5);
        this.addTokenWidget(game, 115, 25, 6);
        this.addTokenWidget(game, 136, 38, 7);
        this.addTokenWidget(game, 136, 64, 8);
        this.addTokenWidget(game, 136, 90, 9);
        this.addTokenWidget(game, 115, 103, 10);
        this.addTokenWidget(game, 94, 116, 11);
        this.addTokenWidget(game, 73, 103, 12);
        this.addTokenWidget(game, 52, 90, 13);
        this.addTokenWidget(game, 52, 64, 14);
        this.addTokenWidget(game, 52, 38, 15);
        this.addTokenWidget(game, 73, 25, 16);
        this.addTokenWidget(game, 94, 12, 17);
        this.addTokenWidget(game, 52, 12, 18);
        this.addTokenWidget(game, 136, 12, 19);
        this.addTokenWidget(game, 52, 116, 20);
        this.addTokenWidget(game, 136, 116, 21);
    }

    private void addTokenWidget(EscritoireGame game, int x, int y, int index) {
        GameTokenWidget gameTokenWidget = new GameTokenWidget(game, this.widgetManager, x, y, index);
        this.widgetManager.add(gameTokenWidget);
    }

    @Override
    protected void m_7286_(PoseStack transform, float partialTicks, int mouseY, int mouseX) {
        super.m_7286_(transform, partialTicks, mouseY, mouseX);
        for (int i = 0; i <= this.tile.getGame().getBountyLevel() / 4; ++i) {
            GuiUtil.drawItemStack(transform, this, this.LEVEL_ITEM, this.f_97735_ + 170 + i * 8, this.f_97736_ + 7);
        }
        this.textLayout.startPage(transform);
        transform.m_85841_(0.5f, 0.5f, 0.5f);
        transform.m_85837_((double)(this.f_97735_ + 170), (double)(this.f_97736_ + 10), 0.0);
        this.textLayout.newLine();
        this.textLayout.newLine();
        MutableComponent attemptNoString = Component.m_237110_((String)"for.gui.escritoire.attempt.number", (Object[])new Object[]{16 - this.tile.getGame().getBountyLevel()}).m_130944_(new ChatFormatting[]{ChatFormatting.UNDERLINE, ChatFormatting.ITALIC});
        this.textLayout.drawLine(transform, (Component)attemptNoString, 170, ColourProperties.INSTANCE.get("gui.mail.lettertext"));
        this.textLayout.newLine();
        Component escritoireText = this.textSource.getText(this.tile.getGame());
        this.textLayout.drawSplitLine(transform, escritoireText, 170, 90, ColourProperties.INSTANCE.get("gui.mail.lettertext"));
        this.textLayout.endPage(transform);
    }

    @Override
    protected void addLedgers() {
        this.addErrorLedger(this.tile);
        this.addHintLedger("escritoire");
    }
}

