/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui;

import com.google.common.base.Preconditions;
import com.google.common.collect.LinkedListMultimap;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import forestry.Forestry;
import forestry.api.ForestryConstants;
import forestry.api.client.ForestrySprites;
import forestry.api.client.IForestryClientApi;
import forestry.api.climate.IClimateProvider;
import forestry.api.core.IErrorLogicSource;
import forestry.api.core.IErrorSource;
import forestry.core.config.ForestryConfig;
import forestry.core.gui.GuiUtil;
import forestry.core.gui.IGuiSizable;
import forestry.core.gui.TextLayoutHelper;
import forestry.core.gui.elements.WindowGui;
import forestry.core.gui.ledgers.ClimateLedger;
import forestry.core.gui.ledgers.HintLedger;
import forestry.core.gui.ledgers.LedgerManager;
import forestry.core.gui.ledgers.OwnerLedger;
import forestry.core.gui.ledgers.PowerLedger;
import forestry.core.gui.slots.ISlotTextured;
import forestry.core.gui.widgets.TankWidget;
import forestry.core.gui.widgets.Widget;
import forestry.core.gui.widgets.WidgetManager;
import forestry.core.owner.IOwnedTile;
import forestry.core.render.ColourProperties;
import forestry.energy.ForestryEnergyStorage;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Properties;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;

public abstract class GuiForestry<C extends AbstractContainerMenu>
extends AbstractContainerScreen<C>
implements IGuiSizable {
    public static final LinkedListMultimap<String, String> HINTS = GuiForestry.readDefaultHints();
    public final ResourceLocation textureFile;
    protected final WidgetManager widgetManager = new WidgetManager(this);
    protected final LedgerManager ledgerManager = new LedgerManager(this);
    protected final TextLayoutHelper textLayout;
    protected final WindowGui<?> window = new WindowGui<GuiForestry>(this.f_97726_, this.f_97727_, this);

    protected GuiForestry(String texture, C menu, Inventory inv, Component title) {
        this(ForestryConstants.forestry(texture), menu, inv, title);
    }

    protected GuiForestry(ResourceLocation texture, C menu, Inventory inv, Component title) {
        super(menu, inv, title);
        this.textureFile = texture;
        this.textLayout = new TextLayoutHelper(this, ColourProperties.INSTANCE);
    }

    public void m_7856_() {
        super.m_7856_();
        int maxLedgerWidth = (this.f_96543_ - this.f_97726_) / 2;
        this.ledgerManager.setMaxWidth(maxLedgerWidth);
        this.ledgerManager.clear();
        this.window.init(this.f_97735_, this.f_97736_);
        this.addLedgers();
    }

    public void m_6574_(Minecraft mc, int width, int height) {
        this.window.setSize(width, height);
        super.m_6574_(mc, width, height);
    }

    public void m_181908_() {
        super.m_181908_();
        this.window.updateClient();
    }

    public void m_6305_(PoseStack transform, int mouseX, int mouseY, float partialTicks) {
        this.window.setMousePosition(mouseX, mouseY);
        this.m_7333_(transform);
        super.m_6305_(transform, mouseX, mouseY, partialTicks);
        this.m_7025_(transform, mouseX, mouseY);
    }

    protected abstract void addLedgers();

    protected final void addErrorLedger(IErrorSource errorSource) {
        this.ledgerManager.add(errorSource);
    }

    protected final void addErrorLedger(IErrorLogicSource errorSource) {
        this.ledgerManager.add(errorSource.getErrorLogic());
    }

    protected final void addClimateLedger(IClimateProvider climatised) {
        this.ledgerManager.add(new ClimateLedger(this.ledgerManager, climatised));
    }

    protected final void addPowerLedger(ForestryEnergyStorage energyStorage) {
        this.ledgerManager.add(new PowerLedger(this.ledgerManager, energyStorage));
    }

    protected final void addHintLedger(String hintsKey) {
        if (((Boolean)ForestryConfig.CLIENT.enableHints.get()).booleanValue()) {
            List hints = HINTS.get((Object)hintsKey);
            this.addHintLedger(hints);
        }
    }

    protected final void addHintLedger(List<String> hints) {
        if (((Boolean)ForestryConfig.CLIENT.enableHints.get()).booleanValue() && !hints.isEmpty()) {
            this.ledgerManager.add(new HintLedger(this.ledgerManager, hints));
        }
    }

    protected final void addOwnerLedger(IOwnedTile ownedTile) {
        this.ledgerManager.add(new OwnerLedger(this.ledgerManager, ownedTile));
    }

    public void m_7379_() {
        super.m_7379_();
        this.ledgerManager.onClose();
    }

    public ColourProperties getFontColor() {
        return ColourProperties.INSTANCE;
    }

    public Font getFontRenderer() {
        return this.f_96547_;
    }

    public boolean m_6375_(double mouseX, double mouseY, int mouseButton) {
        this.ledgerManager.handleMouseClicked(mouseX, mouseY, mouseButton);
        this.widgetManager.handleMouseClicked(mouseX, mouseY, mouseButton);
        if (this.window.onMouseClicked(mouseX, mouseY, mouseButton)) {
            return true;
        }
        return super.m_6375_(mouseX, mouseY, mouseButton);
    }

    public boolean m_6348_(double mouseX, double mouseY, int mouseButton) {
        if (this.widgetManager.handleMouseRelease(mouseX, mouseY, mouseButton) || this.window.onMouseReleased(mouseX, mouseY, mouseButton)) {
            return true;
        }
        return super.m_6348_(mouseX, mouseY, mouseButton);
    }

    public void m_94757_(double mouseX, double mouseY) {
        this.window.onMouseMove(mouseX, mouseY);
    }

    public boolean m_7979_(double mouseX, double mouseY, int mouseButton, double oldMouseX, double oldMouseY) {
        if (this.window.onMouseDrag(mouseX, mouseY)) {
            return true;
        }
        return super.m_7979_(mouseX, mouseY, mouseButton, oldMouseX, oldMouseY);
    }

    public boolean m_7933_(int key, int scanCode, int modifiers) {
        if (this.window.onKeyPressed(key, scanCode, modifiers)) {
            return true;
        }
        return super.m_7933_(key, scanCode, modifiers);
    }

    public boolean m_7920_(int key, int scanCode, int modifiers) {
        if (this.window.onKeyReleased(key, scanCode, modifiers)) {
            return true;
        }
        return super.m_7920_(key, scanCode, modifiers);
    }

    public boolean m_5534_(char codePoint, int modifiers) {
        if (this.window.onCharTyped(codePoint, modifiers)) {
            return true;
        }
        return super.m_5534_(codePoint, modifiers);
    }

    public boolean m_6050_(double mouseX, double mouseY, double deltaWheel) {
        super.m_6050_(mouseX, mouseY, deltaWheel);
        if (deltaWheel != 0.0 && this.window.onMouseScrolled(mouseX, mouseY, deltaWheel)) {
            return true;
        }
        return super.m_6050_(mouseX, mouseY, deltaWheel);
    }

    @Nullable
    public FluidStack getFluidStackAtPosition(double mouseX, double mouseY) {
        for (Widget widget : this.widgetManager.getWidgets()) {
            IFluidTank tank;
            if (!(widget instanceof TankWidget)) continue;
            TankWidget tankWidget = (TankWidget)widget;
            if (!widget.isMouseOver(mouseX - (double)this.f_97735_, mouseY - (double)this.f_97736_) || (tank = tankWidget.getTank()) == null) continue;
            return tank.getFluid();
        }
        return null;
    }

    @Nullable
    protected Slot getSlotAtPosition(double mouseX, double mouseY) {
        for (int k = 0; k < this.f_97732_.f_38839_.size(); ++k) {
            Slot slot = (Slot)this.f_97732_.f_38839_.get(k);
            if (!this.isMouseOverSlot(slot, mouseX, mouseY)) continue;
            return slot;
        }
        return null;
    }

    private boolean isMouseOverSlot(Slot par1Slot, double mouseX, double mouseY) {
        return this.m_6774_(par1Slot.f_40220_, par1Slot.f_40221_, 16, 16, mouseX, mouseY);
    }

    protected boolean m_7467_(double mouseX, double mouseY, int guiLeft, int guiTop, int mouseButton) {
        return !this.window.isMouseOver(mouseX - (double)guiLeft, mouseY - (double)guiTop) && super.m_7467_(mouseX, mouseY, guiLeft, guiTop, mouseButton);
    }

    public void m_97799_(PoseStack transform, Slot slot) {
        if (slot instanceof ISlotTextured) {
            ResourceLocation location;
            ISlotTextured textured = (ISlotTextured)slot;
            ItemStack stack = slot.m_7993_();
            if (stack.m_41619_() && slot.m_6659_() && (location = textured.getBackgroundTexture()) != null) {
                RenderSystem.m_157456_((int)0, (ResourceLocation)ForestrySprites.TEXTURE_ATLAS);
                GuiForestry.m_93200_((PoseStack)transform, (int)slot.f_40220_, (int)slot.f_40221_, (int)this.m_93252_(), (int)16, (int)16, (TextureAtlasSprite)IForestryClientApi.INSTANCE.getTextureManager().getSprite(location));
            }
        }
        super.m_97799_(transform, slot);
    }

    protected void m_7027_(PoseStack transform, int mouseX, int mouseY) {
        this.ledgerManager.drawTooltips(transform, mouseX, mouseY);
        if (this.f_97732_.m_142621_().m_41619_()) {
            GuiUtil.drawToolTips(transform, this, this.widgetManager.getWidgets(), mouseX, mouseY);
            GuiUtil.drawToolTips(transform, this, this.f_169369_, mouseX, mouseY);
            GuiUtil.drawToolTips(transform, this, this.f_97732_.f_38839_, mouseX, mouseY);
            this.window.drawTooltip(transform, mouseX, mouseY);
        }
    }

    protected void m_7286_(PoseStack transform, float partialTicks, int mouseX, int mouseY) {
        this.drawBackground(transform);
        this.widgetManager.updateWidgets(mouseX - this.f_97735_, mouseY - this.f_97736_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        transform.m_85836_();
        transform.m_85837_((double)this.f_97735_, (double)this.f_97736_, 0.0);
        this.drawWidgets(transform);
        transform.m_85849_();
        this.window.draw(transform, mouseX, mouseY);
        this.bindTexture(this.textureFile);
    }

    protected void drawBackground(PoseStack transform) {
        this.bindTexture(this.textureFile);
        this.m_93228_(transform, this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, this.f_97727_);
    }

    protected void drawWidgets(PoseStack transform) {
        this.ledgerManager.drawLedgers(transform);
        this.widgetManager.drawWidgets(transform);
    }

    protected void bindTexture(ResourceLocation texturePath) {
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)texturePath);
    }

    @Override
    public int getSizeX() {
        return this.f_97726_;
    }

    @Override
    public int getSizeY() {
        return this.f_97727_;
    }

    @Override
    public Minecraft getGameInstance() {
        return (Minecraft)Preconditions.checkNotNull((Object)this.f_96541_);
    }

    public List<Rect2i> getExtraGuiAreas() {
        return this.ledgerManager.getLedgerAreas();
    }

    public TextLayoutHelper getTextLayout() {
        return this.textLayout;
    }

    private static LinkedListMultimap<String, String> readDefaultHints() {
        LinkedListMultimap map = LinkedListMultimap.create();
        Properties prop = new Properties();
        try {
            InputStream hintStream = GuiForestry.class.getResourceAsStream("/config/forestry/hints.properties");
            prop.load(hintStream);
        }
        catch (IOException | NullPointerException e) {
            Forestry.LOGGER.error("Failed to load hints file.", (Throwable)e);
        }
        for (String key : prop.stringPropertyNames()) {
            String list = prop.getProperty(key);
            if (list.isEmpty()) continue;
            for (String parsedHint : list.split(";+")) {
                map.put((Object)key, (Object)parsedHint);
            }
        }
        return map;
    }
}

