/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import forestry.api.apiculture.IApiaristTracker;
import forestry.api.genetics.IBreedingTracker;
import forestry.api.genetics.IGenome;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.IMutation;
import forestry.api.genetics.IMutationManager;
import forestry.api.genetics.ISpecies;
import forestry.api.genetics.ISpeciesType;
import forestry.api.genetics.alleles.AllelePair;
import forestry.api.genetics.alleles.IRegistryChromosome;
import forestry.api.genetics.alleles.IValueAllele;
import forestry.api.genetics.capability.IIndividualHandlerItem;
import forestry.core.gui.CycleTimer;
import forestry.core.gui.GuiForestry;
import forestry.core.gui.GuiUtil;
import forestry.core.gui.INaturalistMenu;
import forestry.core.gui.buttons.GuiBetterButton;
import forestry.core.gui.buttons.StandardButtonTextureSets;
import forestry.core.network.packets.PacketGuiSelectRequest;
import forestry.core.render.ColourProperties;
import forestry.core.utils.NetworkUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelAccessor;

public class GuiNaturalistInventory<C extends AbstractContainerMenu>
extends GuiForestry<C> {
    private final ISpeciesType<?, ?> speciesType;
    private final IBreedingTracker breedingTracker;
    private final HashMap<ResourceLocation, ItemStack> iconStacks = new HashMap();
    private final int pageCurrent;
    private final int pageMax;
    private final CycleTimer timer = new CycleTimer(0);

    public GuiNaturalistInventory(C menu, Inventory playerInv, Component name) {
        super("textures/gui/apiaristinventory.png", menu, playerInv, name);
        this.speciesType = ((INaturalistMenu)menu).getSpeciesType();
        this.pageCurrent = ((INaturalistMenu)menu).getCurrentPage();
        this.pageMax = 5;
        this.f_97726_ = 196;
        this.f_97727_ = 202;
        for (ISpecies species : this.speciesType.getAllSpecies()) {
            this.iconStacks.put(species.id(), species.createStack(species.createIndividual(), this.speciesType.getDefaultStage()));
        }
        this.breedingTracker = this.speciesType.getBreedingTracker((LevelAccessor)playerInv.f_35978_.f_19853_, playerInv.f_35978_.m_36316_());
    }

    @Override
    protected void m_7286_(PoseStack transform, float partialTicks, int j, int i) {
        super.m_7286_(transform, partialTicks, j, i);
        this.timer.onDraw();
        MutableComponent header = Component.m_237115_((String)"for.gui.page").m_130946_(" " + (this.pageCurrent + 1) + "/" + this.pageMax);
        this.getFontRenderer().m_92889_(transform, (Component)header, (float)(this.f_97735_ + 95 + this.textLayout.getCenteredOffset((Component)header, 98)), (float)(this.f_97736_ + 10), ColourProperties.INSTANCE.get("gui.title"));
        IIndividual individual = this.getHoveredIndividual();
        if (individual == null) {
            this.displayBreedingStatistics(transform, 10);
        }
        if (individual != null) {
            this.textLayout.startPage(transform);
            IGenome genome = individual.getGenome();
            IRegistryChromosome<? extends ISpecies<?>> speciesChromosome = individual.getType().getKaryotype().getSpeciesChromosome();
            AllelePair<ISpecies<?>> speciesPair = genome.getAllelePair(speciesChromosome);
            boolean pureBred = speciesPair.isSameAlleles();
            ISpecies active = (ISpecies)((IValueAllele)((Object)speciesPair.active())).value();
            this.displaySpeciesInformation(transform, true, active, this.iconStacks.get(active.id()), 10, pureBred ? 25 : 10);
            if (!pureBred) {
                ISpecies inactive = (ISpecies)((IValueAllele)((Object)speciesPair.inactive())).value();
                this.displaySpeciesInformation(transform, individual.isAnalyzed(), inactive, this.iconStacks.get(inactive.id()), 10, 10);
            }
            this.textLayout.endPage(transform);
        }
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        this.m_142416_((GuiEventListener)new GuiBetterButton(this.f_97735_ + 99, this.f_97736_ + 7, StandardButtonTextureSets.LEFT_BUTTON_SMALL, b -> {
            if (this.pageCurrent > 0) {
                this.flipPage(this.pageCurrent - 1);
            }
        }));
        this.m_142416_((GuiEventListener)new GuiBetterButton(this.f_97735_ + 180, this.f_97736_ + 7, StandardButtonTextureSets.RIGHT_BUTTON_SMALL, b -> {
            if (this.pageCurrent < this.pageMax - 1) {
                this.flipPage(this.pageCurrent + 1);
            }
        }));
    }

    private void flipPage(int page) {
        ((INaturalistMenu)this.f_97732_).onFlipPage();
        NetworkUtil.sendToServer(new PacketGuiSelectRequest(page, 0));
    }

    @Nullable
    private IIndividual getHoveredIndividual() {
        Slot slot = this.f_97734_;
        if (slot == null) {
            return null;
        }
        if (!slot.m_6657_()) {
            return null;
        }
        if (!slot.m_7993_().m_41782_()) {
            return null;
        }
        if (!this.speciesType.isMember(slot.m_7993_())) {
            return null;
        }
        return IIndividualHandlerItem.getIndividual(slot.m_7993_());
    }

    private void displayBreedingStatistics(PoseStack transform, int x) {
        this.textLayout.startPage(transform);
        this.textLayout.drawLine(transform, (Component)Component.m_237115_((String)"for.gui.speciescount").m_130946_(": ").m_130946_(this.breedingTracker.getSpeciesBred() + "/" + this.speciesType.getSpeciesCount()), x);
        this.textLayout.newLine();
        this.textLayout.newLine();
        IBreedingTracker iBreedingTracker = this.breedingTracker;
        if (iBreedingTracker instanceof IApiaristTracker) {
            IApiaristTracker tracker = (IApiaristTracker)iBreedingTracker;
            this.textLayout.drawLine(transform, (Component)Component.m_237115_((String)"for.gui.queens").m_130946_(": ").m_130946_(Integer.toString(tracker.getQueenCount())), x);
            this.textLayout.newLine();
            this.textLayout.drawLine(transform, (Component)Component.m_237115_((String)"for.gui.princesses").m_130946_(": ").m_130946_(Integer.toString(tracker.getPrincessCount())), x);
            this.textLayout.newLine();
            this.textLayout.drawLine(transform, (Component)Component.m_237115_((String)"for.gui.drones").m_130946_(": ").m_130946_(Integer.toString(tracker.getDroneCount())), x);
            this.textLayout.newLine();
        }
        this.textLayout.endPage(transform);
    }

    private void displaySpeciesInformation(PoseStack transform, boolean analyzed, ISpecies<?> species, ItemStack iconStack, int x, int maxMutationCount) {
        if (!analyzed) {
            this.textLayout.drawLine(transform, (Component)Component.m_237115_((String)"for.gui.unknown"), x);
            return;
        }
        this.textLayout.drawLine(transform, (Component)species.getDisplayName(), x);
        GuiUtil.drawItemStack(transform, this, iconStack, this.f_97735_ + x + 67, this.f_97736_ + this.textLayout.getLineY() - 4);
        this.textLayout.newLine();
        int columnWidth = 16;
        int column = 10;
        IMutationManager<?> manager = this.speciesType.getMutations();
        List<List<IMutation<ISpecies<?>>>> mutations = GuiNaturalistInventory.splitMutations(manager.getMutationsFrom(species), maxMutationCount);
        for (IMutation combination : this.timer.getCycledItem(mutations, Collections::emptyList)) {
            if (combination.isSecret()) continue;
            if (this.breedingTracker.isDiscovered(combination)) {
                this.drawMutationIcon(transform, combination, species, column);
            } else {
                this.drawUnknownIcon(transform, combination, column);
            }
            if ((column += columnWidth) <= 75) continue;
            column = 10;
            this.textLayout.newLine(18);
        }
        this.textLayout.newLine();
        this.textLayout.newLine();
    }

    private void drawMutationIcon(PoseStack transform, IMutation<?> combination, ISpecies<?> species, int x) {
        GuiUtil.drawItemStack(transform, this, this.iconStacks.get(combination.getPartner(species).id()), this.f_97735_ + x, this.f_97736_ + this.textLayout.getLineY());
    }

    private void drawUnknownIcon(PoseStack transform, IMutation<?> mutation, int x) {
        int column;
        int line;
        float chance = mutation.getChance();
        if (chance >= 20.0f) {
            line = 16;
            column = 228;
        } else if (chance >= 15.0f) {
            line = 16;
            column = 212;
        } else if (chance >= 12.0f) {
            line = 16;
            column = 196;
        } else if (chance >= 10.0f) {
            line = 0;
            column = 228;
        } else if (chance >= 5.0f) {
            line = 0;
            column = 212;
        } else {
            line = 0;
            column = 196;
        }
        this.bindTexture(this.textureFile);
        this.m_93228_(transform, this.f_97735_ + x, this.f_97736_ + this.textLayout.getLineY(), column, line, 16, 16);
    }

    private static List<List<? extends IMutation<?>>> splitMutations(List<? extends IMutation<?>> mutations, int maxMutationCount) {
        int size = mutations.size();
        if (size <= maxMutationCount) {
            return Collections.singletonList(mutations);
        }
        ImmutableList.Builder subGroups = new ImmutableList.Builder();
        LinkedList subList = new LinkedList();
        subGroups.add(subList);
        int count = 0;
        for (IMutation<?> mutation : mutations) {
            if (mutation.isSecret()) continue;
            if (count % maxMutationCount == 0 && count != 0) {
                subList = new LinkedList();
                subGroups.add(subList);
            }
            subList.add(mutation);
            ++count;
        }
        return subGroups.build();
    }

    @Override
    protected void addLedgers() {
        this.addHintLedger("naturalist.chest");
    }
}

