/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import forestry.api.core.tooltips.IToolTipProvider;
import forestry.api.core.tooltips.ToolTip;
import forestry.core.gui.GuiForestry;
import forestry.core.gui.IGuiSizable;
import java.text.NumberFormat;
import java.util.Collection;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.world.item.ItemStack;

public class GuiUtil {
    public static void drawItemStack(PoseStack transform, GuiForestry<?> gui, ItemStack stack, int xPos, int yPos) {
        GuiUtil.drawItemStack(transform, gui.getFontRenderer(), stack, xPos, yPos);
    }

    public static void drawItemStack(PoseStack transform, Font font, ItemStack stack, int xPos, int yPos) {
        PoseStack itemRendererStack = RenderSystem.m_157191_();
        itemRendererStack.m_85836_();
        itemRendererStack.m_166854_(transform.m_85850_().m_85861_());
        ItemRenderer itemRender = Minecraft.m_91087_().m_91291_();
        itemRender.m_115203_(stack, xPos, yPos);
        itemRender.m_115174_(font, stack, xPos, yPos, null);
        itemRendererStack.m_85849_();
        RenderSystem.m_157182_();
    }

    public static <S extends Screen> void drawToolTips(PoseStack transform, S screen, @Nullable IToolTipProvider provider, ToolTip toolTips, int mouseX, int mouseY) {
        if (!toolTips.isEmpty()) {
            transform.m_85836_();
            if (provider == null || provider.isRelativeToGui()) {
                transform.m_85837_((double)(-((IGuiSizable)screen).getGuiLeft()), (double)(-((IGuiSizable)screen).getGuiTop()), 0.0);
            }
            screen.m_169388_(transform, toolTips.getLines(), Optional.empty(), mouseX, mouseY);
            transform.m_85849_();
        }
    }

    public static <S extends Screen> void drawToolTips(PoseStack transform, S screen, Collection<?> objects, int mouseX, int mouseY) {
        for (Object obj : objects) {
            ToolTip tips;
            IToolTipProvider provider;
            if (!(obj instanceof IToolTipProvider) || !(provider = (IToolTipProvider)obj).isToolTipVisible()) continue;
            int mX = mouseX;
            int mY = mouseY;
            if (provider.isRelativeToGui()) {
                mX -= ((IGuiSizable)screen).getGuiLeft();
                mY -= ((IGuiSizable)screen).getGuiTop();
            }
            if ((tips = provider.getToolTip(mX, mY)) == null) continue;
            boolean mouseOver = provider.isHovering(mX, mY);
            tips.onTick(mouseOver);
            if (!mouseOver || !tips.isReady()) continue;
            tips.refresh();
            GuiUtil.drawToolTips(transform, screen, provider, tips, mouseX, mouseY);
        }
    }

    public static String formatEnergyValue(int energy) {
        NumberFormat format = NumberFormat.getIntegerInstance(Minecraft.m_91087_().getLocale());
        return format.format(energy) + " RF";
    }

    public static String formatRate(int rate) {
        return GuiUtil.formatEnergyValue(rate) + "/t";
    }
}

