/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui;

import com.google.common.base.Preconditions;
import com.mojang.blaze3d.vertex.PoseStack;
import forestry.core.gui.IGuiSizable;
import forestry.core.gui.elements.WindowGui;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class GuiWindow
extends Screen
implements IGuiSizable {
    protected final WindowGui window;
    protected final int xSize;
    protected final int ySize;
    protected int guiLeft;
    protected int guiTop;

    public GuiWindow(int xSize, int ySize, Component title) {
        super(title);
        this.xSize = xSize;
        this.ySize = ySize;
        this.window = new WindowGui<GuiWindow>(xSize, ySize, this);
        this.addElements();
    }

    protected void addElements() {
    }

    public boolean m_7043_() {
        return false;
    }

    public void m_86600_() {
        this.window.updateClient();
    }

    public void m_6305_(PoseStack transform, int mouseX, int mouseY, float partialTicks) {
        this.window.setMousePosition(mouseX, mouseY);
        super.m_6305_(transform, mouseX, mouseY, partialTicks);
        this.window.draw(transform, mouseX, mouseY);
    }

    public void m_7856_() {
        super.m_7856_();
        this.guiLeft = (this.f_96543_ - this.xSize) / 2;
        this.guiTop = (this.f_96544_ - this.ySize) / 2;
        this.window.init(this.guiLeft, this.guiTop);
    }

    public void m_6574_(Minecraft mc, int width, int height) {
        this.window.setSize(width, height);
        super.m_6574_(mc, width, height);
    }

    public void m_94757_(double mouseX, double mouseY) {
        this.window.onMouseMove(mouseX, mouseY);
    }

    public boolean m_7979_(double mouseX, double mouseY, int mouseButton, double oldMouseX, double oldMouseY) {
        if (this.window.onMouseDrag(mouseX, mouseY)) {
            return true;
        }
        return super.m_7979_(mouseX, mouseY, mouseButton, oldMouseX, oldMouseY);
    }

    public boolean m_7933_(int key, int scanCode, int modifiers) {
        if (key == 256) {
            this.f_96541_.m_91152_(null);
            if (this.f_96541_.f_91080_ == null) {
                this.f_96541_.m_7440_(true);
            }
        }
        if (this.window.onKeyPressed(key, scanCode, modifiers)) {
            return true;
        }
        return super.m_7933_(key, scanCode, modifiers);
    }

    public boolean m_7920_(int key, int scanCode, int modifiers) {
        if (this.window.onKeyPressed(key, scanCode, modifiers)) {
            return true;
        }
        return super.m_7920_(key, scanCode, modifiers);
    }

    public boolean m_5534_(char codePoint, int modifiers) {
        if (this.window.onCharTyped(codePoint, modifiers)) {
            return true;
        }
        return super.m_5534_(codePoint, modifiers);
    }

    public boolean m_6375_(double mouseX, double mouseY, int mouseButton) {
        if (this.window.onMouseClicked(mouseX, mouseY, mouseButton)) {
            return true;
        }
        return super.m_6375_(mouseX, mouseY, mouseButton);
    }

    public boolean m_6348_(double mouseX, double mouseY, int mouseButton) {
        if (this.window.onMouseReleased(mouseX, mouseY, mouseButton)) {
            return true;
        }
        return super.m_6348_(mouseX, mouseY, mouseButton);
    }

    public boolean m_6050_(double mouseX, double mouseY, double deltaWheel) {
        if (deltaWheel != 0.0 && this.window.onMouseScrolled(mouseX, mouseY, deltaWheel)) {
            return true;
        }
        return super.m_6050_(mouseX, mouseY, deltaWheel);
    }

    @Override
    public int getGuiLeft() {
        return this.guiLeft;
    }

    @Override
    public int getGuiTop() {
        return this.guiTop;
    }

    @Override
    public int getSizeX() {
        return this.xSize;
    }

    @Override
    public int getSizeY() {
        return this.ySize;
    }

    @Override
    public Minecraft getGameInstance() {
        return (Minecraft)Preconditions.checkNotNull((Object)this.f_96541_);
    }
}

