/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import forestry.core.gui.GuiForestry;
import forestry.core.render.ColourProperties;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;

public class TextLayoutHelper {
    private static final int LINE_HEIGHT = 12;
    private final GuiForestry<?> guiForestry;
    private final int defaultFontColor;
    public int column0;
    public int column1;
    public int column2;
    public int line;

    public TextLayoutHelper(GuiForestry<?> gui, ColourProperties fontColour) {
        this.guiForestry = gui;
        this.defaultFontColor = fontColour.get("gui.screen");
    }

    public void startPage(PoseStack matrices) {
        this.line = 12;
        matrices.m_85836_();
    }

    public void startPage(PoseStack matrices, int column0, int column1, int column2) {
        this.column0 = column0;
        this.column1 = column1;
        this.column2 = column2;
        this.startPage(matrices);
    }

    public int getLineY() {
        return this.line;
    }

    public void newLine() {
        this.line += 12;
    }

    public void newLineCompressed() {
        this.line += 10;
    }

    public void newLine(int lineHeight) {
        this.line += lineHeight;
    }

    public void endPage(PoseStack matrices) {
        matrices.m_85849_();
    }

    public void drawRow(PoseStack transform, Component text0, Component text1, Component text2, int colour0, int colour1, int colour2) {
        this.drawLine(transform, text0, this.column0, colour0);
        this.drawLine(transform, text1, this.column1, colour1);
        this.drawLine(transform, text2, this.column2, colour2);
    }

    public void drawRow(PoseStack transform, Component text0, Component text1, int colour0, int colour1) {
        this.drawLine(transform, text0, this.column0, colour0);
        this.drawLine(transform, text1, this.column1, colour1);
    }

    public void drawLine(PoseStack transform, Component text, int x) {
        this.drawLine(transform, text, x, this.defaultFontColor);
    }

    public void drawCenteredLine(PoseStack transform, Component text, int x, int color) {
        this.drawCenteredLine(transform, text, x, this.guiForestry.getSizeX(), color);
    }

    public void drawCenteredLine(PoseStack transform, Component text, int x, int width, int color) {
        this.drawCenteredLine(transform, text, x, 0, width, color);
    }

    public void drawCenteredLine(PoseStack transform, Component text, int x, int y, int width, int color) {
        this.guiForestry.getFontRenderer().m_92889_(transform, text, (float)(this.guiForestry.getGuiLeft() + x + this.getCenteredOffset(text, width)), (float)(this.guiForestry.getGuiTop() + y + this.line), color);
    }

    public void drawLine(PoseStack transform, String text, int x, int color) {
        this.drawLine(transform, text, x, 0, color);
    }

    public void drawLine(PoseStack transform, Component text, int x, int color) {
        this.drawLine(transform, text, x, 0, color);
    }

    public void drawLine(PoseStack transform, String text, int x, int y, int color) {
        this.guiForestry.getFontRenderer().m_92883_(transform, text, (float)(this.guiForestry.getGuiLeft() + x), (float)(this.guiForestry.getGuiTop() + y + this.line), color);
    }

    public void drawLine(PoseStack transform, Component text, int x, int y, int color) {
        this.guiForestry.getFontRenderer().m_92889_(transform, text, (float)(this.guiForestry.getGuiLeft() + x), (float)(this.guiForestry.getGuiTop() + y + this.line), color);
    }

    public void drawSplitLine(PoseStack transform, String text, int x, int maxWidth, int color) {
        this.drawSplitLine(transform, (Component)Component.m_237113_((String)text), x, maxWidth, color);
    }

    public void drawSplitLine(PoseStack transform, Component text, int x, int maxWidth, int color) {
        Font font = this.guiForestry.getFontRenderer();
        float xStart = this.guiForestry.getGuiLeft() + x;
        float yStart = this.guiForestry.getGuiTop() + this.line;
        for (FormattedCharSequence formattedcharsequence : font.m_92923_((FormattedText)text, maxWidth)) {
            font.m_92877_(transform, formattedcharsequence, xStart, yStart, color);
            yStart += 9.0f;
        }
    }

    public int getCenteredOffset(Component text) {
        return this.getCenteredOffset(text, this.guiForestry.getSizeX());
    }

    public int getCenteredOffset(Component text, int xWidth) {
        return (xWidth - this.guiForestry.getFontRenderer().m_92852_((FormattedText)text)) / 2;
    }
}

