/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui.elements;

import com.google.common.base.Preconditions;
import forestry.api.core.ToleranceType;
import forestry.api.genetics.IGenome;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.alleles.IAllele;
import forestry.api.genetics.alleles.IChromosome;
import forestry.api.genetics.alleles.IIntegerAllele;
import forestry.api.genetics.alleles.IIntegerChromosome;
import forestry.api.genetics.alleles.IValueAllele;
import forestry.api.genetics.alleles.IValueChromosome;
import forestry.api.genetics.gatgets.DatabaseMode;
import forestry.core.gui.elements.Alignment;
import forestry.core.gui.elements.GuiElement;
import forestry.core.gui.elements.GuiElementFactory;
import forestry.core.gui.elements.layouts.ContainerElement;
import forestry.core.gui.elements.layouts.FlexLayout;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;

public class DatabaseElement
extends ContainerElement {
    private DatabaseMode mode = DatabaseMode.ACTIVE;
    @Nullable
    private IIndividual individual;
    private int secondColumn;

    public DatabaseElement(int width) {
        this.setSize(width, -1);
        this.setLayout(FlexLayout.vertical(0));
        this.secondColumn = width / 2;
    }

    public void init(DatabaseMode mode, IIndividual individual, int secondColumn) {
        this.mode = mode;
        this.individual = individual;
        this.secondColumn = secondColumn;
    }

    @Nullable
    public IIndividual getIndividual() {
        return this.individual;
    }

    public IGenome getGenome() {
        Preconditions.checkNotNull((Object)this.individual, (Object)"Database Element has not been initialised.");
        return this.individual.getGenome();
    }

    public void addFertilityLine(Component chromosomeName, IIntegerChromosome chromosome, int texOffset) {
        IGenome genome = this.getGenome();
        IIntegerAllele activeAllele = genome.getActiveAllele(chromosome);
        IIntegerAllele inactiveAllele = genome.getInactiveAllele(chromosome);
        boolean active = this.mode == DatabaseMode.ACTIVE;
        IIntegerAllele allele = active ? activeAllele : inactiveAllele;
        this.addLine(chromosomeName, GuiElementFactory.INSTANCE.createFertilityInfo(allele, texOffset));
    }

    public void addToleranceLine(IValueChromosome<ToleranceType> chromosome) {
        IValueAllele allele = (IValueAllele)((Object)this.getGenome().getActiveAllele(chromosome));
        this.addLine((Component)Component.m_237113_((String)"  ").m_7220_((Component)Component.m_237115_((String)"for.gui.tolerance")), GuiElementFactory.INSTANCE.createToleranceInfo(chromosome, allele));
    }

    public void addLine(Component firstText, Component secondText, boolean dominant) {
        this.addLine(firstText, secondText, GuiElementFactory.INSTANCE.guiStyle, GuiElementFactory.INSTANCE.getStateStyle(dominant));
    }

    public void addLine(Component leftText, Function<Boolean, Component> toText, boolean dominant) {
        this.addLine(leftText, toText.apply(this.mode == DatabaseMode.ACTIVE), dominant);
    }

    public void addLine(Component leftText, Function<Boolean, Component> toText, IChromosome chromosome) {
        IGenome genome = this.getGenome();
        Object activeAllele = genome.getActiveAllele(chromosome);
        Object inactiveAllele = genome.getInactiveAllele(chromosome);
        boolean active = this.mode == DatabaseMode.ACTIVE;
        Object allele = active ? activeAllele : inactiveAllele;
        this.addLine(leftText, toText.apply(active), allele.dominant());
    }

    public <A extends IAllele> void addLine(Component chromosomeName, IChromosome<A> chromosome) {
        this.addLine(chromosomeName, (A allele, Boolean b) -> chromosome.getDisplayName(allele), chromosome);
    }

    public void addLine(Component firstText, Component secondText, Style firstStyle, Style secondStyle) {
        ContainerElement first = this.addSplitText(this.preferredSize.width, firstText, firstStyle);
        ContainerElement second = this.addSplitText(this.preferredSize.width, secondText, secondStyle);
        this.addLine(first, (GuiElement)second);
    }

    private ContainerElement addSplitText(int width, Component text, Style style) {
        Font fontRenderer = Minecraft.m_91087_().f_91062_;
        ContainerElement vertical = GuiElementFactory.vertical(width, 0);
        fontRenderer.m_92865_().m_92393_((FormattedText)text, width, style, (contents, contentsStyle) -> vertical.label(contents.getString()).setStyle(style));
        return vertical;
    }

    private void addLine(Component chromosomeName, GuiElement right) {
        int center = this.preferredSize.width / 2;
        ContainerElement first = this.addSplitText(center, chromosomeName, GuiElementFactory.INSTANCE.guiStyle);
        this.addLine(first, right);
    }

    private void addLine(GuiElement first, GuiElement second) {
        ContainerElement panel = this.pane(this.preferredSize.width, -1);
        first.setAlign(Alignment.MIDDLE_LEFT);
        second.setAlign(Alignment.MIDDLE_LEFT);
        panel.add(first);
        panel.add(second);
        second.setXPosition(this.secondColumn);
    }

    public <A extends IAllele> void addLine(Component chromosomeName, BiFunction<A, Boolean, Component> toText, IChromosome<A> chromosome) {
        this.addAlleleRow(chromosomeName, toText, chromosome, null);
    }

    private <A extends IAllele> void addAlleleRow(Component chromosomeName, BiFunction<A, Boolean, Component> toString, IChromosome<A> chromosome, @Nullable Boolean dominant) {
        IGenome genome = this.getGenome();
        A activeAllele = genome.getActiveAllele(chromosome);
        A inactiveAllele = genome.getInactiveAllele(chromosome);
        boolean active = this.mode == DatabaseMode.ACTIVE;
        A allele = active ? activeAllele : inactiveAllele;
        this.addLine(chromosomeName, toString.apply(allele, active), dominant != null ? dominant.booleanValue() : allele.dominant());
    }
}

