/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui.elements;

import forestry.api.ForestryConstants;
import forestry.api.core.ToleranceType;
import forestry.api.genetics.IAlyzerPlugin;
import forestry.api.genetics.IBreedingTracker;
import forestry.api.genetics.IMutation;
import forestry.api.genetics.ISpecies;
import forestry.api.genetics.ISpeciesType;
import forestry.api.genetics.alleles.IChromosome;
import forestry.api.genetics.alleles.IIntegerAllele;
import forestry.api.genetics.alleles.IValueAllele;
import forestry.api.genetics.gatgets.IDatabasePlugin;
import forestry.api.genetics.gatgets.IGeneticAnalyzer;
import forestry.api.genetics.gatgets.IGeneticAnalyzerProvider;
import forestry.core.genetics.mutations.EnumMutateChance;
import forestry.core.gui.Drawable;
import forestry.core.gui.GuiConstants;
import forestry.core.gui.elements.Alignment;
import forestry.core.gui.elements.DrawableElement;
import forestry.core.gui.elements.GeneticAnalyzer;
import forestry.core.gui.elements.GuiElement;
import forestry.core.gui.elements.ItemElement;
import forestry.core.gui.elements.Window;
import forestry.core.gui.elements.layouts.ContainerElement;
import forestry.core.gui.elements.layouts.FlexLayout;
import forestry.core.render.ColourProperties;
import java.awt.Insets;
import java.util.Map;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.world.item.ItemStack;

public enum GuiElementFactory implements ResourceManagerReloadListener
{
    INSTANCE;

    private static final ResourceLocation TEXTURE;
    public Style dominantStyle = Style.f_131099_;
    public Style recessiveStyle = Style.f_131099_;
    public Style guiStyle = Style.f_131099_;
    public Style guiTitleStyle = Style.f_131099_;
    public Style databaseTitle = Style.f_131099_;
    public Style binomial = Style.f_131099_;
    private static final Drawable QUESTION_MARK;
    private static final Drawable DOWN_SYMBOL;
    private static final Drawable UP_SYMBOL;
    private static final Drawable BOOTH_SYMBOL;
    private static final Drawable NONE_SYMBOL;

    public void m_6213_(ResourceManager resourceManager) {
        this.dominantStyle = Style.f_131099_.m_131148_(TextColor.m_131266_((int)ColourProperties.INSTANCE.get("gui.beealyzer.dominant")));
        this.recessiveStyle = Style.f_131099_.m_131148_(TextColor.m_131266_((int)ColourProperties.INSTANCE.get("gui.beealyzer.recessive")));
        this.guiStyle = Style.f_131099_.m_131148_(TextColor.m_131266_((int)ColourProperties.INSTANCE.get("gui.screen")));
        this.guiTitleStyle = Style.f_131099_.m_131148_(TextColor.m_131266_((int)ColourProperties.INSTANCE.get("gui.title")));
        this.databaseTitle = Style.f_131099_.m_131148_(TextColor.m_131266_((int)13612347)).m_131162_(Boolean.valueOf(true));
        this.binomial = Style.f_131099_.m_131148_(TextColor.m_131266_((int)ColourProperties.INSTANCE.get("gui.beealyzer.binomial")));
    }

    public IGeneticAnalyzer createAnalyzer(Window window, int xPos, int yPos, boolean rightBoarder, IGeneticAnalyzerProvider provider) {
        return new GeneticAnalyzer(window, xPos, yPos, rightBoarder, provider);
    }

    public static ContainerElement horizontal(int height, int spacing, Insets margin) {
        return (ContainerElement)new ContainerElement().setLayout(FlexLayout.horizontal(spacing, margin)).setSize(-1, height);
    }

    public static ContainerElement vertical(int width, int spacing, Insets margin) {
        return (ContainerElement)new ContainerElement().setLayout(FlexLayout.vertical(spacing, margin)).setSize(width, -1);
    }

    public static ContainerElement horizontal(int height, int spacing) {
        return (ContainerElement)new ContainerElement().setLayout(FlexLayout.horizontal(spacing)).setSize(-1, height);
    }

    public static ContainerElement vertical(int width, int spacing) {
        return (ContainerElement)new ContainerElement().setLayout(FlexLayout.vertical(spacing)).setSize(width, -1);
    }

    public static ContainerElement pane() {
        return new ContainerElement();
    }

    public static ContainerElement pane(int width, int height) {
        return (ContainerElement)new ContainerElement().setSize(width, height);
    }

    public static ContainerElement pane(int xPos, int yPos, int width, int height) {
        return (ContainerElement)new ContainerElement().setPreferredBounds(xPos, yPos, width, height);
    }

    public final Style getStateStyle(boolean dominant) {
        return dominant ? this.dominantStyle : this.recessiveStyle;
    }

    public final Style getGuiStyle() {
        return this.guiStyle;
    }

    public GuiElement createFertilityInfo(IIntegerAllele fertilityAllele, int texOffset) {
        MutableComponent fertilityString = Component.m_237113_((String)(fertilityAllele.value() + " x"));
        ContainerElement layout = GuiElementFactory.horizontal(-1, 2);
        layout.label((Component)fertilityString, this.getStateStyle(fertilityAllele.dominant()));
        layout.drawable(0, -1, new Drawable(TEXTURE, 60, 240 + texOffset, 12, 8));
        return layout;
    }

    public GuiElement createToleranceInfo(IChromosome<IValueAllele<ToleranceType>> chromosome, IValueAllele<ToleranceType> toleranceAllele) {
        Style textStyle = this.getStateStyle(toleranceAllele.dominant());
        ToleranceType tolerance = toleranceAllele.value();
        MutableComponent component = null;
        ContainerElement layout = GuiElementFactory.horizontal(-1, 2);
        switch (tolerance) {
            case BOTH_1: 
            case BOTH_2: 
            case BOTH_3: 
            case BOTH_4: 
            case BOTH_5: {
                layout.add(GuiElementFactory.createBothSymbol(0, -1));
                break;
            }
            case DOWN_1: 
            case DOWN_2: 
            case DOWN_3: 
            case DOWN_4: 
            case DOWN_5: {
                layout.add(GuiElementFactory.createDownSymbol(0, -1));
                break;
            }
            case UP_1: 
            case UP_2: 
            case UP_3: 
            case UP_4: 
            case UP_5: {
                layout.add(GuiElementFactory.createUpSymbol(0, -1));
                break;
            }
            default: {
                layout.add(GuiElementFactory.createNoneSymbol(0, -1));
                component = Component.m_237113_((String)"(0)");
            }
        }
        if (component == null) {
            component = Component.m_237113_((String)"(").m_7220_((Component)chromosome.getDisplayName(toleranceAllele)).m_130946_(")");
        }
        layout.label((Component)component).setStyle(textStyle);
        return layout;
    }

    public GuiElement createMutationResultant(int x, int y, int width, int height, IMutation<?> mutation, IBreedingTracker breedingTracker) {
        if (breedingTracker.isDiscovered(mutation)) {
            ContainerElement element = new ContainerElement();
            element.setPreferredBounds(x, y, width, height);
            IAlyzerPlugin plugin = mutation.getType().getAlyzerPlugin();
            Map<ISpecies<?>, ItemStack> iconStacks = plugin.getIconStacks();
            ItemStack firstPartner = iconStacks.get(mutation.getFirstParent());
            ItemStack secondPartner = iconStacks.get(mutation.getSecondParent());
            element.add(new ItemElement(0, 0, firstPartner), GuiElementFactory.createProbabilityAdd(mutation, 21, 4), new ItemElement(33, 0, secondPartner));
            return element;
        }
        if (mutation.isSecret()) {
            return null;
        }
        return GuiElementFactory.createUnknownMutationGroup(x, y, width, height, mutation);
    }

    public ContainerElement createMutation(int x, int y, int width, int height, IMutation<?> mutation, ISpecies<?> species, IBreedingTracker breedingTracker) {
        if (breedingTracker.isDiscovered(mutation)) {
            ContainerElement element = GuiElementFactory.pane(x, y, width, height);
            ISpeciesType<?, ?> speciesType = mutation.getType();
            IDatabasePlugin plugin = speciesType.getDatabasePlugin();
            Map<ISpecies<?>, ItemStack> iconStacks = plugin.getIndividualStacks();
            ItemStack partner = iconStacks.get(mutation.getPartner(species));
            Object resultSpecies = mutation.getResult();
            ItemStack result = iconStacks.get(resultSpecies);
            element.add(new ItemElement(0, 0, partner), new ItemElement(33, 0, result));
            GuiElementFactory.createProbabilityArrow(element, mutation, 18, 4, breedingTracker);
            return element;
        }
        if (mutation.isSecret()) {
            throw new IllegalArgumentException("Mutation is secret, cannot reveal");
        }
        return GuiElementFactory.createUnknownMutationGroup(x, y, width, height, mutation, breedingTracker);
    }

    private static ContainerElement createUnknownMutationGroup(int x, int y, int width, int height, IMutation<?> mutation) {
        ContainerElement element = GuiElementFactory.pane(x, y, width, height);
        element.add(GuiElementFactory.createQuestionMark(0, 0), GuiElementFactory.createProbabilityAdd(mutation, 21, 4), GuiElementFactory.createQuestionMark(32, 0));
        return element;
    }

    private static ContainerElement createUnknownMutationGroup(int x, int y, int width, int height, IMutation<?> mutation, IBreedingTracker breedingTracker) {
        ContainerElement element = GuiElementFactory.pane(x, y, width, height);
        element.add(GuiElementFactory.createQuestionMark(0, 0), GuiElementFactory.createQuestionMark(32, 0));
        GuiElementFactory.createProbabilityArrow(element, mutation, 18, 4, breedingTracker);
        return element;
    }

    private static void createProbabilityArrow(ContainerElement element, IMutation<?> combination, int x, int y, IBreedingTracker breedingTracker) {
        float chance = combination.getChance();
        int line = 247;
        int column = 100;
        switch (EnumMutateChance.rateChance(chance)) {
            case HIGHEST: {
                column = 100;
                break;
            }
            case HIGHER: {
                column = 115;
                break;
            }
            case HIGH: {
                column = 130;
                break;
            }
            case NORMAL: {
                column = 145;
                break;
            }
            case LOW: {
                column = 160;
                break;
            }
            case LOWEST: {
                column = 175;
                break;
            }
        }
        element.drawable(x, y, new Drawable(TEXTURE, column, line, 15, 9));
        boolean researched = breedingTracker.isResearched(combination);
        if (researched) {
            element.label("+").setStyle(GuiConstants.DEFAULT_STYLE).setAlign(Alignment.TOP_LEFT).setSize(10, 10).setLocation(x + 9, y + 1);
        }
    }

    private static DrawableElement createProbabilityAdd(IMutation mutation, int x, int y) {
        float chance = mutation.getChance();
        int line = 247;
        int column = 190;
        switch (EnumMutateChance.rateChance(chance)) {
            case HIGHEST: {
                column = 190;
                break;
            }
            case HIGHER: {
                column = 199;
                break;
            }
            case HIGH: {
                column = 208;
                break;
            }
            case NORMAL: {
                column = 217;
                break;
            }
            case LOW: {
                column = 226;
                break;
            }
            case LOWEST: {
                column = 235;
            }
        }
        return new DrawableElement(x, y, new Drawable(TEXTURE, column, line, 9, 9));
    }

    private static DrawableElement createQuestionMark(int x, int y) {
        return new DrawableElement(x, y, QUESTION_MARK);
    }

    private static DrawableElement createDownSymbol(int x, int y) {
        return new DrawableElement(x, y, DOWN_SYMBOL);
    }

    private static DrawableElement createUpSymbol(int x, int y) {
        return new DrawableElement(x, y, UP_SYMBOL);
    }

    private static DrawableElement createBothSymbol(int x, int y) {
        return new DrawableElement(x, y, BOOTH_SYMBOL);
    }

    private static DrawableElement createNoneSymbol(int x, int y) {
        return new DrawableElement(x, y, NONE_SYMBOL);
    }

    static {
        TEXTURE = ForestryConstants.forestry("textures/gui/database_mutation_screen.png");
        QUESTION_MARK = new Drawable(TEXTURE, 78, 240, 16, 16);
        DOWN_SYMBOL = new Drawable(TEXTURE, 0, 247, 15, 9);
        UP_SYMBOL = new Drawable(TEXTURE, 15, 247, 15, 9);
        BOOTH_SYMBOL = new Drawable(TEXTURE, 30, 247, 15, 9);
        NONE_SYMBOL = new Drawable(TEXTURE, 45, 247, 15, 9);
    }
}

