/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui.elements;

import com.mojang.blaze3d.vertex.PoseStack;
import forestry.core.gui.elements.GuiElement;
import forestry.core.gui.elements.IValueElement;
import java.awt.Rectangle;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.network.chat.Component;

public class TextEditElement
extends GuiElement
implements IValueElement<String> {
    @Nullable
    private EditBox field;
    private int maxLength;
    private Predicate<String> validator;

    public TextEditElement(int maxLength) {
        this(maxLength, null);
    }

    public TextEditElement(int maxLength, @Nullable Predicate<String> validator) {
        this.maxLength = maxLength;
        this.validator = validator;
    }

    public TextEditElement() {
    }

    @Override
    public void setAssignedBounds(Rectangle bounds) {
        super.setAssignedBounds(bounds);
        this.field = new EditBox(Minecraft.m_91087_().f_91062_, 0, 0, bounds.width, bounds.height, (Component)Component.m_237119_());
        this.field.m_94182_(false);
        if (this.maxLength > 0) {
            this.field.m_94199_(this.maxLength);
        }
    }

    @Override
    public boolean onKeyPressed(int keyCode, int scanCode, int modifiers) {
        return this.field != null && this.field.m_7933_(keyCode, scanCode, modifiers);
    }

    @Override
    public boolean onCharTyped(char keyCode, int modifiers) {
        return this.field != null && this.field.m_5534_(keyCode, modifiers);
    }

    @Override
    public boolean onMouseClicked(double mouseX, double mouseY, int mouseButton) {
        return this.field != null && this.field.m_6375_(mouseX, mouseY, mouseButton);
    }

    public TextEditElement setValidator(Predicate<String> validator) {
        if (this.field == null) {
            return this;
        }
        this.field.m_94153_(validator);
        return this;
    }

    @Override
    public String getValue() {
        return this.field.m_94155_();
    }

    @Override
    public void setValue(String value) {
        if (!this.field.m_94155_().equals(value)) {
            this.field.m_94144_(value);
        }
    }

    @Override
    public void drawElement(PoseStack transform, int mouseX, int mouseY) {
        if (this.field == null) {
            return;
        }
        this.field.m_6305_(transform, mouseY, mouseX, 0.0f);
    }

    @Override
    public boolean canFocus() {
        return true;
    }

    @Override
    public boolean canMouseOver() {
        return true;
    }
}

