/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui.elements.layouts;

import forestry.Forestry;
import forestry.core.gui.elements.GuiElement;
import forestry.core.gui.elements.layouts.ContainerElement;
import forestry.core.gui.elements.layouts.Layout;
import forestry.core.gui.elements.layouts.LayoutDirection;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.List;

public class FlexLayout
implements Layout {
    public static final Insets DEFAULT_MARGIN = new Insets(0, 0, 0, 0);
    public static final Insets LEFT_MARGIN = new Insets(0, 4, 0, 0);
    protected final LayoutDirection direction;
    protected final int spacing;
    protected final Insets margin;

    public static FlexLayout horizontal(int spacing) {
        return FlexLayout.horizontal(spacing, DEFAULT_MARGIN);
    }

    public static FlexLayout vertical(int spacing) {
        return FlexLayout.vertical(spacing, DEFAULT_MARGIN);
    }

    public static FlexLayout horizontal(int spacing, Insets margin) {
        return new FlexLayout(LayoutDirection.HORIZONTAL, spacing, margin);
    }

    public static FlexLayout vertical(int spacing, Insets margin) {
        return new FlexLayout(LayoutDirection.VERTICAL, spacing, margin);
    }

    protected FlexLayout(LayoutDirection direction, int spacing) {
        this(direction, spacing, DEFAULT_MARGIN);
    }

    protected FlexLayout(LayoutDirection direction, int spacing, Insets margin) {
        this.direction = direction;
        this.spacing = spacing;
        this.margin = margin;
    }

    public boolean isHorizontal() {
        return this.direction == LayoutDirection.HORIZONTAL;
    }

    @Override
    public void layoutContainer(Rectangle bounds, List<GuiElement> elements) {
        int sizeExtent = this.getDirectionExtent(bounds.getSize());
        if (sizeExtent > 0) {
            this.handleBound(bounds, elements);
        } else {
            this.handleUnbound(bounds, elements);
        }
    }

    @Override
    public Dimension getLayoutSize(ContainerElement container) {
        boolean unboundOpposite;
        Dimension preferredSize = container.getPreferredSize();
        int sizeExtent = this.getDirectionExtent(preferredSize);
        int oppositeExtent = this.getOppositeExtent(preferredSize);
        boolean unboundExtent = sizeExtent < 0;
        boolean bl = unboundOpposite = oppositeExtent < 0;
        if (unboundExtent) {
            int n = sizeExtent = this.direction == LayoutDirection.HORIZONTAL ? this.margin.left : this.margin.top;
        }
        if (unboundOpposite) {
            sizeExtent = this.direction == LayoutDirection.HORIZONTAL ? this.margin.top : this.margin.left;
        }
        for (GuiElement element : container.getElements()) {
            Dimension elementSize = new Dimension(element.getLayoutSize());
            int elementExtent = this.getDirectionExtent(elementSize);
            int elementOpposite = this.getOppositeExtent(elementSize);
            if (elementExtent < 0) {
                Forestry.LOGGER.error(String.format("Tried to an widget with unbound extent to a flex layout. Direction: %s; Widget: %s; Size:%s", new Object[]{this.direction, element, elementSize}));
                continue;
            }
            if (unboundExtent) {
                sizeExtent += elementExtent;
            }
            oppositeExtent = Math.max(oppositeExtent, elementOpposite);
        }
        return this.direction == LayoutDirection.HORIZONTAL ? new Dimension(sizeExtent, oppositeExtent) : new Dimension(oppositeExtent, sizeExtent);
    }

    protected void handleUnbound(Rectangle bounds, List<GuiElement> elements) {
        int sizeExtent = this.direction == LayoutDirection.HORIZONTAL ? this.margin.left : this.margin.top;
        for (GuiElement element : elements) {
            Dimension preferredSize = new Dimension(element.getLayoutSize());
            int elementExtent = this.getDirectionExtent(preferredSize);
            if (elementExtent < 0) {
                Forestry.LOGGER.error(String.format("Tried to an widget with unbound extent to a flex layout. Direction: %s; Widget: %s; Size:%s", new Object[]{this.direction, element, preferredSize}));
                continue;
            }
            sizeExtent += elementExtent;
            Point pos = new Point();
            if (this.direction == LayoutDirection.HORIZONTAL) {
                pos.x = sizeExtent;
                if (preferredSize.height < 0) {
                    preferredSize.height = bounds.height;
                }
            } else {
                pos.y = sizeExtent;
                if (preferredSize.width < 0) {
                    preferredSize.width = bounds.width;
                }
            }
            Rectangle elementBounds = new Rectangle(pos, preferredSize);
            Layout.alignElement(bounds, elementBounds, element.getAlign(), this.direction);
            element.setAssignedBounds(elementBounds);
        }
        sizeExtent += this.direction == LayoutDirection.HORIZONTAL ? this.margin.right : this.margin.bottom;
        if (this.direction == LayoutDirection.HORIZONTAL) {
            bounds.width = sizeExtent;
        } else {
            bounds.height = sizeExtent;
        }
    }

    protected void handleBound(Rectangle bounds, List<GuiElement> elements) {
        int sizeExtent = this.getDirectionExtent(bounds.getSize());
        int flexExtent = this.getFlexExtent(elements, sizeExtent -= (this.direction == LayoutDirection.HORIZONTAL ? this.margin.left : this.margin.top) + (this.direction == LayoutDirection.HORIZONTAL ? this.margin.right : this.margin.bottom));
        int position = this.direction == LayoutDirection.HORIZONTAL ? this.margin.left : this.margin.top;
        for (GuiElement element : elements) {
            Dimension size = new Dimension(element.getLayoutSize());
            Point pos = new Point();
            if (this.direction == LayoutDirection.HORIZONTAL) {
                pos.x = position;
                if (size.width < 0) {
                    size.width = flexExtent;
                }
                position += this.spacing + size.width;
            } else {
                pos.y = position;
                if (size.height < 0) {
                    size.height = flexExtent;
                }
                position += this.spacing + size.height;
            }
            Rectangle elementBounds = new Rectangle(pos, size);
            Layout.alignElement(bounds, elementBounds, element.getAlign(), this.direction);
            element.setAssignedBounds(elementBounds);
        }
    }

    private int getFlexExtent(List<GuiElement> elements, int totalSize) {
        int usedExtent = 0;
        int usedCount = 0;
        for (GuiElement element : elements) {
            Dimension preferredSize = element.getLayoutSize();
            int elementExtent = this.getDirectionExtent(preferredSize);
            if (elementExtent <= 0) continue;
            usedExtent += elementExtent;
            ++usedCount;
        }
        usedExtent += (elements.size() - 1) * this.spacing;
        int unknownCount = elements.size() - usedCount;
        if (unknownCount == 0) {
            return 0;
        }
        return (totalSize - usedExtent) / unknownCount;
    }

    private int getDirectionExtent(Dimension preferredSize) {
        return this.direction == LayoutDirection.HORIZONTAL ? preferredSize.width : preferredSize.height;
    }

    private int getOppositeExtent(Dimension preferredSize) {
        return this.direction == LayoutDirection.HORIZONTAL ? preferredSize.height : preferredSize.width;
    }
}

