/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui.elements.layouts;

import forestry.core.gui.elements.Alignment;
import forestry.core.gui.elements.GuiElement;
import forestry.core.gui.elements.layouts.ContainerElement;
import forestry.core.gui.elements.layouts.LayoutDirection;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.List;
import javax.annotation.Nullable;

public interface Layout {
    public void layoutContainer(Rectangle var1, List<GuiElement> var2);

    default public Dimension getLayoutSize(ContainerElement container) {
        return container.getPreferredSize();
    }

    public static void alignElement(Rectangle parent, Rectangle element, Alignment align, @Nullable LayoutDirection direction) {
        if ((direction == null || direction == LayoutDirection.VERTICAL) && parent.width >= 0 && parent.width > element.width) {
            element.x = (int)((float)(parent.width - element.width) * align.getXOffset()) + element.x;
        }
        if ((direction == null || direction == LayoutDirection.HORIZONTAL) && parent.height >= 0 && parent.height > element.height) {
            element.y = (int)((float)(parent.height - element.height) * align.getYOffset()) + element.y;
        }
    }

    public static void alignElement(Rectangle parent, Rectangle element, Alignment align) {
        Layout.alignElement(parent, element, align, null);
    }
}

