/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui.elements.text;

import com.mojang.blaze3d.vertex.PoseStack;
import forestry.core.gui.elements.text.LabelElement;
import java.awt.Dimension;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;

public abstract class AbstractTextElement<T, E extends AbstractTextElement<T, E>>
extends LabelElement {
    public static final Font FONT_RENDERER = Minecraft.m_91087_().f_91062_;
    public static final int DEFAULT_HEIGHT;
    protected T text;
    protected int originalWidth;
    protected boolean fitText;
    protected boolean shadow = false;

    public AbstractTextElement(T text) {
        this(0, 0, -1, DEFAULT_HEIGHT, text, true);
    }

    public AbstractTextElement(int xPos, int yPos, int width, int height, T text, boolean fitText) {
        super(xPos, yPos, width, height);
        this.originalWidth = width;
        this.text = text;
        this.setFitText(fitText);
    }

    public E setFitText(boolean fitText) {
        this.fitText = fitText;
        this.requestLayout();
        return (E)((Object)this);
    }

    public boolean isFitText() {
        return this.fitText;
    }

    public E setShadow(boolean value) {
        this.shadow = value;
        return (E)((Object)this);
    }

    public boolean hasShadow() {
        return this.shadow;
    }

    public Style getStyle() {
        if (this.text instanceof MutableComponent) {
            return ((MutableComponent)this.text).m_7383_();
        }
        return Style.f_131099_;
    }

    public E setStyle(Style style) {
        T t = this.text;
        if (t instanceof MutableComponent) {
            MutableComponent mutable = (MutableComponent)t;
            mutable.m_6270_(style);
        }
        this.requestLayout();
        return (E)((Object)this);
    }

    public T getText() {
        return this.text;
    }

    public boolean setText(T value) {
        this.text = value;
        return true;
    }

    @Override
    public abstract void drawElement(PoseStack var1, int var2, int var3);

    protected abstract int calcWidth(Font var1);

    @Override
    public Dimension getLayoutSize() {
        Dimension layoutSize = super.getLayoutSize();
        if (this.fitText || layoutSize.width < 0) {
            return new Dimension(this.calcWidth(FONT_RENDERER), layoutSize.height);
        }
        return layoutSize;
    }

    static {
        Objects.requireNonNull(FONT_RENDERER);
        DEFAULT_HEIGHT = 9 + 3;
    }
}

