/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui.elements.text;

import com.google.common.base.Preconditions;
import forestry.api.core.tooltips.ITextInstance;
import forestry.core.gui.elements.GuiElement;
import forestry.core.gui.elements.text.ComponentText;
import forestry.core.gui.elements.text.ProcessorText;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;

public abstract class LabelElement
extends GuiElement {
    public LabelElement(int xPos, int yPos, int width, int height) {
        super(xPos, yPos, width, height);
    }

    public abstract LabelElement setStyle(Style var1);

    public abstract LabelElement setFitText(boolean var1);

    public abstract LabelElement setValue(Object var1);

    public static class Builder
    implements ITextInstance<Builder, Builder, LabelElement> {
        @Nullable
        private final Consumer<GuiElement> parentAdder;
        @Nullable
        private final Function<LabelElement, GuiElement> finisher;
        private final Object root;
        boolean fitText = false;
        boolean shadow = false;

        public Builder(Object root) {
            this(null, root, null);
        }

        public Builder(@Nullable Consumer<GuiElement> parentAdder, Object root) {
            this(parentAdder, root, null);
        }

        public Builder(@Nullable Consumer<GuiElement> parentAdder, Object root, @Nullable Function<LabelElement, GuiElement> finisher) {
            this.parentAdder = parentAdder;
            this.finisher = finisher;
            if (root instanceof String) {
                String string = (String)root;
                root = Component.m_237113_((String)string);
            }
            this.root = root;
        }

        @Override
        @Nullable
        public Component lastComponent() {
            Object object = this.root;
            if (object instanceof Component) {
                Component component = (Component)object;
                return component;
            }
            return null;
        }

        @Override
        public Builder add(Component line) {
            Object object = this.root;
            if (object instanceof MutableComponent) {
                MutableComponent mutable = (MutableComponent)object;
                mutable.m_7220_(line);
            }
            return this;
        }

        @Override
        public Builder singleLine() {
            return this;
        }

        @Override
        public Builder cast() {
            return this;
        }

        @Override
        public LabelElement create() {
            Object element;
            Preconditions.checkNotNull((Object)this.root);
            Object object = this.root;
            if (object instanceof Component) {
                Component component = (Component)object;
                element = ((ComponentText)new ComponentText(component).setFitText(this.fitText)).setShadow(this.shadow);
            } else {
                object = this.root;
                if (object instanceof FormattedCharSequence) {
                    FormattedCharSequence formatted = (FormattedCharSequence)object;
                    element = ((ProcessorText)new ProcessorText(formatted).setFitText(this.fitText)).setShadow(this.shadow);
                } else {
                    throw new IllegalStateException(String.format("Tried to create text widget with an invalid type of text '%s'", this.root.getClass()));
                }
            }
            if (this.finisher != null) {
                element = (LabelElement)this.finisher.apply((LabelElement)((Object)element));
            }
            if (this.parentAdder != null) {
                this.parentAdder.accept((GuiElement)((Object)element));
            }
            return element;
        }

        public Builder fitText() {
            this.fitText = true;
            return this;
        }

        public Builder shadow() {
            this.shadow = true;
            return this;
        }

        public Builder setStyle(Style style) {
            Object object = this.root;
            if (object instanceof MutableComponent) {
                MutableComponent mutable = (MutableComponent)object;
                mutable.m_6270_(style);
            }
            return this;
        }

        public Builder withStyle(Style style) {
            Object object = this.root;
            if (object instanceof MutableComponent) {
                MutableComponent mutable = (MutableComponent)object;
                mutable.m_130948_(style);
            }
            return this;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }
    }
}

