/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui.ledgers;

import com.mojang.blaze3d.vertex.PoseStack;
import forestry.api.core.IError;
import forestry.core.gui.ledgers.Ledger;
import forestry.core.gui.ledgers.LedgerManager;
import forestry.core.utils.StringUtil;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;

public class ErrorLedger
extends Ledger {
    @Nullable
    private IError state;

    public ErrorLedger(LedgerManager manager) {
        super(manager, "error", false);
        this.maxHeight = 72;
    }

    public void setState(@Nullable IError state) {
        this.state = state;
        if (state != null) {
            int lineHeight = StringUtil.getLineHeight(this.maxTextWidth, new FormattedText[]{this.getTooltip(), Component.m_237115_((String)state.getHelpTranslationKey())});
            this.maxHeight = lineHeight + 20;
        }
    }

    @Override
    public void draw(PoseStack transform, int y, int x) {
        if (this.state == null) {
            return;
        }
        this.drawBackground(transform, y, x);
        int xIcon = x + 5;
        int xBody = x + 14;
        int xHeader = x + 24;
        this.drawSprite(transform, this.state.getSprite(), xIcon, y += 4);
        y += 4;
        if (this.isFullyOpened()) {
            y += this.drawHeader(transform, this.getTooltip(), xHeader, y);
            MutableComponent helpString = Component.m_237115_((String)this.state.getHelpTranslationKey());
            this.drawSplitText(transform, (Component)helpString, xBody, y += 4, this.maxTextWidth);
        }
    }

    @Override
    public boolean isVisible() {
        return this.state != null;
    }

    @Override
    public Component getTooltip() {
        if (this.state == null) {
            return Component.m_237113_((String)"");
        }
        return Component.m_237115_((String)this.state.getDescriptionTranslationKey());
    }
}

