/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui.ledgers;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import forestry.api.core.IError;
import forestry.api.core.IErrorSource;
import forestry.api.core.tooltips.ToolTip;
import forestry.core.config.SessionVars;
import forestry.core.gui.GuiForestry;
import forestry.core.gui.GuiUtil;
import forestry.core.gui.ledgers.ErrorLedger;
import forestry.core.gui.ledgers.Ledger;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.Rect2i;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class LedgerManager {
    private final List<Ledger> ledgers = new ArrayList<Ledger>();
    private final List<ErrorLedger> errorLedgers = new ArrayList<ErrorLedger>();
    private IErrorSource errorSource;
    private int maxWidth;
    public final GuiForestry<?> gui;

    public LedgerManager(GuiForestry<?> gui) {
        this.gui = gui;
        this.errorSource = IErrorSource.EMPTY;
    }

    public void setMaxWidth(int maxWidth) {
        this.maxWidth = maxWidth;
    }

    public void add(IErrorSource errorSource) {
        this.errorSource = errorSource;
        int maxErrorLedgerCount = (this.gui.getSizeY() - 10) / 24;
        for (int i = 0; i < maxErrorLedgerCount; ++i) {
            this.errorLedgers.add(new ErrorLedger(this));
        }
    }

    public void clear() {
        this.ledgers.clear();
    }

    public void add(Ledger ledger) {
        this.ledgers.add(ledger);
        if (SessionVars.getOpenedLedger() != null && ledger.getClass().equals(SessionVars.getOpenedLedger())) {
            ledger.setFullyOpen();
        }
    }

    public void onClose() {
        for (Ledger ledger : this.ledgers) {
            ledger.onGuiClosed();
        }
    }

    public void insert(Ledger ledger) {
        this.ledgers.add(this.ledgers.size() - 1, ledger);
    }

    @Nullable
    private Ledger getAtPosition(double mX, double mY) {
        if (!this.ledgers.isEmpty()) {
            int xShift = this.gui.getGuiLeft() + this.gui.getSizeX();
            int yShift = this.gui.getGuiTop() + 8;
            for (Ledger ledger : this.ledgers) {
                if (!ledger.isVisible()) continue;
                ledger.currentShiftX = xShift;
                ledger.currentShiftY = yShift;
                if (ledger.intersects(mX, mY)) {
                    return ledger;
                }
                yShift += ledger.getHeight();
            }
        }
        int xShiftError = this.gui.getGuiLeft();
        int yShiftError = this.gui.getGuiTop() + 8;
        for (ErrorLedger errorLedger : this.errorLedgers) {
            if (!errorLedger.isVisible()) continue;
            errorLedger.currentShiftX = xShiftError - errorLedger.getWidth();
            errorLedger.currentShiftY = yShiftError;
            if (errorLedger.intersects(mX, mY)) {
                return errorLedger;
            }
            yShiftError += errorLedger.getHeight();
        }
        return null;
    }

    public List<Rect2i> getLedgerAreas() {
        ArrayList<Rect2i> areas = new ArrayList<Rect2i>();
        for (Ledger ledger : this.ledgers) {
            if (!ledger.isVisible()) continue;
            Rect2i area = ledger.getArea();
            areas.add(area);
        }
        return areas;
    }

    public void drawLedgers(PoseStack transform) {
        int yPos = 8;
        for (Ledger ledger : this.ledgers) {
            ledger.update();
            if (!ledger.isVisible()) continue;
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            ledger.setPosition(this.gui.getSizeX(), yPos);
            ledger.draw(transform);
            yPos += ledger.getHeight();
        }
        ArrayList<IError> errorStates = new ArrayList<IError>(this.errorSource.getErrors());
        yPos = 8;
        int index = 0;
        for (ErrorLedger errorLedger : this.errorLedgers) {
            if (index >= errorStates.size()) {
                errorLedger.setState(null);
                continue;
            }
            IError errorState = (IError)errorStates.get(index++);
            errorLedger.setState(errorState);
            errorLedger.update();
            if (!errorLedger.isVisible()) continue;
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            errorLedger.draw(transform, yPos, -errorLedger.getWidth());
            yPos += errorLedger.getHeight();
        }
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public void drawTooltips(PoseStack transform, int mouseX, int mouseY) {
        Ledger ledger = this.getAtPosition(mouseX, mouseY);
        if (ledger != null) {
            ToolTip toolTip = new ToolTip();
            toolTip.add(ledger.getTooltip());
            GuiUtil.drawToolTips(transform, this.gui, null, toolTip, mouseX, mouseY);
        }
    }

    public void handleMouseClicked(double x, double y, int mouseButton) {
        Ledger ledger;
        if (mouseButton == 0 && (ledger = this.getAtPosition(x, y)) != null && !ledger.handleMouseClicked(x, y, mouseButton)) {
            List<Ledger> toggleLedgers = this.ledgers.contains(ledger) ? this.ledgers : this.errorLedgers;
            for (Ledger other : toggleLedgers) {
                if (other == ledger || !other.isOpen()) continue;
                other.toggleOpen();
            }
            ledger.toggleOpen();
        }
    }

    public boolean hasOpenedLedger() {
        for (Ledger ledger : this.ledgers) {
            if (!ledger.isOpen()) continue;
            return true;
        }
        return false;
    }

    public int getMaxWidth() {
        return this.maxWidth;
    }
}

