/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui.ledgers;

import com.mojang.blaze3d.vertex.PoseStack;
import forestry.api.client.ForestrySprites;
import forestry.api.client.IForestryClientApi;
import forestry.core.gui.GuiUtil;
import forestry.core.gui.ledgers.Ledger;
import forestry.core.gui.ledgers.LedgerManager;
import forestry.energy.ForestryEnergyStorage;
import net.minecraft.network.chat.Component;

public class PowerLedger
extends Ledger {
    private final ForestryEnergyStorage energyStorage;

    public PowerLedger(LedgerManager manager, ForestryEnergyStorage energyStorage) {
        super(manager, "power");
        this.energyStorage = energyStorage;
        this.maxHeight = 94;
    }

    @Override
    public void draw(PoseStack transform, int y, int x) {
        this.drawBackground(transform, y, x);
        this.drawSprite(transform, IForestryClientApi.INSTANCE.getTextureManager().getSprite(ForestrySprites.MISC_ENERGY), x + 3, y + 4);
        if (!this.isFullyOpened()) {
            return;
        }
        int xHeader = x + 22;
        int xBody = x + 12;
        this.drawHeader(transform, (Component)Component.m_237115_((String)"for.gui.energy"), xHeader, y + 8);
        this.drawSubheader(transform, (Component)Component.m_237115_((String)"for.gui.stored").m_130946_(":"), xBody, y + 20);
        this.drawText(transform, GuiUtil.formatEnergyValue(this.energyStorage.getEnergyStored()), xBody, y + 32);
        this.drawSubheader(transform, (Component)Component.m_237115_((String)"for.gui.maxenergy").m_130946_(":"), xBody, y + 44);
        this.drawText(transform, GuiUtil.formatEnergyValue(this.energyStorage.getMaxEnergyStored()), xBody, y + 56);
        this.drawSubheader(transform, (Component)Component.m_237115_((String)"for.gui.maxenergyreceive").m_130946_(":"), xBody, y + 68);
        this.drawText(transform, GuiUtil.formatEnergyValue(this.energyStorage.getMaxEnergyReceived()), xBody, y + 80);
    }

    @Override
    public Component getTooltip() {
        return Component.m_237113_((String)GuiUtil.formatEnergyValue(this.energyStorage.getEnergyStored()));
    }
}

