/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui.slots;

import forestry.api.ForestryConstants;
import forestry.core.gui.slots.ISlotTextured;
import forestry.core.gui.slots.SlotWatched;
import forestry.core.tiles.IFilterSlotDelegate;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;

public class SlotFiltered
extends SlotWatched
implements ISlotTextured {
    private final IFilterSlotDelegate filterSlotDelegate;
    @Nullable
    private ResourceLocation backgroundTexture = null;
    private ResourceLocation blockedTexture = ForestryConstants.forestry("slots/blocked");

    public <T extends Container & IFilterSlotDelegate> SlotFiltered(T inventory, int slotIndex, int xPos, int yPos) {
        super(inventory, slotIndex, xPos, yPos);
        this.filterSlotDelegate = inventory;
    }

    public boolean m_5857_(ItemStack itemstack) {
        int slotIndex = this.getSlotIndex();
        return !this.filterSlotDelegate.isLocked(slotIndex) && (itemstack.m_41619_() || this.filterSlotDelegate.canSlotAccept(slotIndex, itemstack));
    }

    public SlotFiltered setBlockedTexture(String ident) {
        this.blockedTexture = ForestryConstants.forestry(ident);
        return this;
    }

    public SlotFiltered setBackgroundTexture(String backgroundTexture) {
        this.backgroundTexture = ForestryConstants.forestry(backgroundTexture);
        return this;
    }

    @Override
    @Nullable
    public ResourceLocation getBackgroundTexture() {
        ItemStack stack = this.m_7993_();
        if (!this.m_5857_(stack)) {
            return this.blockedTexture;
        }
        if (this.backgroundTexture != null) {
            return this.backgroundTexture;
        }
        return null;
    }
}

