/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui.slots;

import forestry.worktable.tiles.ICrafterWorktable;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.RecipeHolder;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.ForgeEventFactory;

public class WorktableSlot
extends Slot {
    private final CraftingContainer craftMatrix;
    private final ICrafterWorktable crafter;
    private final Player player;
    private int amountCrafted;

    public WorktableSlot(Player player, CraftingContainer craftMatrix, Container craftingDisplay, ICrafterWorktable crafter, int slot, int xPos, int yPos) {
        super(craftingDisplay, slot, xPos, yPos);
        this.craftMatrix = craftMatrix;
        this.crafter = crafter;
        this.player = player;
    }

    public boolean m_5857_(ItemStack pStack) {
        return false;
    }

    protected void m_7169_(ItemStack pStack, int pAmount) {
        this.amountCrafted += pAmount;
        this.m_5845_(pStack);
    }

    protected void m_5845_(ItemStack stack) {
        Container container;
        if (this.amountCrafted > 0) {
            stack.m_41678_(this.player.f_19853_, this.player, this.amountCrafted);
            ForgeEventFactory.firePlayerCraftingEvent((Player)this.player, (ItemStack)stack, (Container)this.craftMatrix);
        }
        if ((container = this.f_40218_) instanceof RecipeHolder) {
            RecipeHolder holder = (RecipeHolder)container;
            holder.m_8015_(this.player);
        }
        this.amountCrafted = 0;
    }

    public ItemStack m_6201_(int amount) {
        if (!this.m_6657_()) {
            return ItemStack.f_41583_;
        }
        return this.m_7993_();
    }

    public boolean m_8010_(Player player) {
        return this.crafter.mayPickup(this.getSlotIndex());
    }

    public ItemStack m_7993_() {
        return this.crafter.getResult(this.craftMatrix, this.player.f_19853_);
    }

    public boolean m_6657_() {
        return !this.m_7993_().m_41619_() && this.crafter.mayPickup(this.getSlotIndex());
    }

    public void m_142406_(Player pPlayer, ItemStack stack) {
        if (this.crafter.onCraftingStart(this.player)) {
            this.m_5845_(stack);
            this.crafter.onCraftingComplete(this.player);
        }
    }
}

