/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui.widgets;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import forestry.api.client.ForestrySprites;
import forestry.api.client.IForestryClientApi;
import forestry.api.core.tooltips.ToolTip;
import forestry.core.gui.GuiUtil;
import forestry.core.gui.widgets.Widget;
import forestry.core.gui.widgets.WidgetManager;
import forestry.core.network.packets.PacketGuiSelectRequest;
import forestry.core.tiles.EscritoireGame;
import forestry.core.tiles.EscritoireGameToken;
import forestry.core.utils.NetworkUtil;
import forestry.core.utils.SoundUtil;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class GameTokenWidget
extends Widget {
    private final ItemStack HIDDEN_TOKEN = new ItemStack((ItemLike)Items.f_42517_);
    private final EscritoireGame game;
    private final int index;

    public GameTokenWidget(EscritoireGame game, WidgetManager manager, int xPos, int yPos, int index) {
        super(manager, xPos, yPos);
        this.game = game;
        this.index = index;
        this.width = 20;
        this.height = 20;
    }

    @Nullable
    private EscritoireGameToken getToken() {
        return this.game.getToken(this.index);
    }

    @Override
    public void draw(PoseStack transform, int startX, int startY) {
        EscritoireGameToken token = this.getToken();
        if (token == null) {
            return;
        }
        int tokenColour = token.getTokenColour();
        float colorR = (float)(tokenColour >> 16 & 0xFF) / 255.0f;
        float colorG = (float)(tokenColour >> 8 & 0xFF) / 255.0f;
        float colorB = (float)(tokenColour & 0xFF) / 255.0f;
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.manager.gui.textureFile);
        RenderSystem.m_69482_();
        RenderSystem.m_157429_((float)colorR, (float)colorG, (float)colorB, (float)1.0f);
        this.manager.gui.m_93228_(transform, startX + this.xPos, startY + this.yPos, 228, 0, 22, 22);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ItemStack tokenStack = this.HIDDEN_TOKEN;
        if (token.isVisible()) {
            tokenStack = token.getTokenStack();
        }
        GuiUtil.drawItemStack(transform, this.manager.gui, tokenStack, startX + this.xPos + 3, startY + this.yPos + 3);
        ResourceLocation overlayToken = token.getOverlayToken();
        if (overlayToken != null) {
            RenderSystem.m_69465_();
            RenderSystem.m_157456_((int)0, (ResourceLocation)ForestrySprites.TEXTURE_ATLAS);
            TextureAtlasSprite icon = IForestryClientApi.INSTANCE.getTextureManager().getSprite(overlayToken);
            GuiComponent.m_93200_((PoseStack)transform, (int)(startX + this.xPos + 3), (int)(startY + this.yPos + 3), (int)this.manager.gui.m_93252_(), (int)16, (int)16, (TextureAtlasSprite)icon);
            RenderSystem.m_69482_();
        }
    }

    @Override
    public ToolTip getToolTip(int mouseX, int mouseY) {
        EscritoireGameToken token = this.getToken();
        if (token == null || !token.isVisible()) {
            return null;
        }
        ToolTip tooltip = new ToolTip();
        tooltip.add(token.getTooltip());
        return tooltip;
    }

    @Override
    public void handleMouseClick(double mouseX, double mouseY, int mouseButton) {
        this.game.choose(this.index);
        NetworkUtil.sendToServer(new PacketGuiSelectRequest(this.index, 0));
        SoundUtil.playButtonClick();
    }
}

