/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui.widgets;

import com.mojang.blaze3d.vertex.PoseStack;
import forestry.api.core.tooltips.ToolTip;
import forestry.core.circuits.ISocketable;
import forestry.core.circuits.ISolderingIron;
import forestry.core.circuits.ItemCircuitBoard;
import forestry.core.gui.GuiUtil;
import forestry.core.gui.IContainerSocketed;
import forestry.core.gui.widgets.Widget;
import forestry.core.gui.widgets.WidgetManager;
import forestry.core.utils.ItemTooltipUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class SocketWidget
extends Widget {
    private final ISocketable tile;
    private final int slot;
    private final ToolTip toolTip = new ToolTip(250){

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public void refresh() {
            SocketWidget.this.toolTip.clear();
            ItemStack stack = SocketWidget.this.tile.getSocket(SocketWidget.this.slot);
            if (!stack.m_41619_()) {
                SocketWidget.this.toolTip.addAll(ItemTooltipUtil.getInformation(stack));
                SocketWidget.this.toolTip.add((Component)Component.m_237115_((String)"for.gui.socket.remove").m_130940_(ChatFormatting.ITALIC));
            } else {
                SocketWidget.this.toolTip.add((Component)Component.m_237115_((String)"for.gui.emptysocket"));
            }
        }
    };

    public SocketWidget(WidgetManager manager, int xPos, int yPos, ISocketable tile, int slot) {
        super(manager, xPos, yPos);
        this.tile = tile;
        this.slot = slot;
    }

    @Override
    public void draw(PoseStack transform, int startX, int startY) {
        ItemStack socketStack = this.tile.getSocket(this.slot);
        if (!socketStack.m_41619_()) {
            GuiUtil.drawItemStack(transform, Minecraft.m_91087_().f_91062_, socketStack, this.xPos, this.yPos);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ToolTip getToolTip(int mouseX, int mouseY) {
        return this.toolTip;
    }

    @Override
    public void handleMouseClick(double mouseX, double mouseY, int mouseButton) {
        ItemStack itemstack = Minecraft.m_91087_().f_91074_.f_36096_.m_142621_();
        if (itemstack.m_41619_()) {
            if (mouseButton == 2) {
                // empty if block
            }
            return;
        }
        Item held = itemstack.m_41720_();
        AbstractContainerMenu container = this.manager.gui.m_6262_();
        if (!(container instanceof IContainerSocketed)) {
            return;
        }
        IContainerSocketed containerSocketed = (IContainerSocketed)container;
        if (held instanceof ItemCircuitBoard) {
            containerSocketed.handleChipsetClick(this.slot);
        } else if (held instanceof ISolderingIron) {
            containerSocketed.handleSolderingIronClick(this.slot);
        }
    }
}

