/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui.widgets;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import forestry.api.core.IToolPipette;
import forestry.api.core.tooltips.ToolTip;
import forestry.core.fluids.StandardTank;
import forestry.core.gui.IContainerLiquidTanks;
import forestry.core.gui.widgets.Widget;
import forestry.core.gui.widgets.WidgetManager;
import forestry.core.utils.ResourceUtil;
import forestry.farming.gui.ContainerFarm;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;

@OnlyIn(value=Dist.CLIENT)
public class TankWidget
extends Widget {
    private int overlayTexX = 176;
    private int overlayTexY = 0;
    private int slot;
    protected boolean drawOverlay = true;

    public TankWidget(WidgetManager manager, int xPos, int yPos, int slot) {
        super(manager, xPos, yPos);
        this.slot = slot;
        this.height = 58;
    }

    public TankWidget setOverlayOrigin(int x, int y) {
        this.overlayTexX = x;
        this.overlayTexY = y;
        return this;
    }

    @Nullable
    public IFluidTank getTank() {
        AbstractContainerMenu container = this.manager.gui.m_6262_();
        if (container instanceof IContainerLiquidTanks) {
            return ((IContainerLiquidTanks)container).getTank(this.slot);
        }
        if (container instanceof ContainerFarm) {
            return ((ContainerFarm)container).getTank(this.slot);
        }
        return null;
    }

    @Override
    public void draw(PoseStack transform, int startX, int startY) {
        Fluid fluid;
        RenderSystem.m_69461_();
        IFluidTank tank = this.getTank();
        if (tank == null || tank.getCapacity() <= 0) {
            return;
        }
        FluidStack contents = tank.getFluid();
        if (!contents.isEmpty() && contents.getAmount() > 0 && contents.getFluid() != null && (fluid = contents.getFluid()) != null) {
            IClientFluidTypeExtensions type = IClientFluidTypeExtensions.of((Fluid)fluid);
            ResourceLocation fluidStill = type.getStillTexture(contents);
            TextureAtlasSprite fluidStillSprite = null;
            if (fluidStill != null) {
                fluidStillSprite = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(fluidStill);
            }
            if (fluidStillSprite == null) {
                fluidStillSprite = ResourceUtil.getMissingTexture();
            }
            int fluidColor = type.getTintColor(contents);
            int scaledAmount = contents.getAmount() * this.height / tank.getCapacity();
            if (contents.getAmount() > 0 && scaledAmount < 1) {
                scaledAmount = 1;
            }
            if (scaledAmount > this.height) {
                scaledAmount = this.height;
            }
            RenderSystem.m_157456_((int)0, (ResourceLocation)TextureAtlas.f_118259_);
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            TankWidget.setGLColorFromInt(fluidColor);
            int xTileCount = this.width / 16;
            int xRemainder = this.width - xTileCount * 16;
            int yTileCount = scaledAmount / 16;
            int yRemainder = scaledAmount - yTileCount * 16;
            int yStart = startY + this.height;
            for (int xTile = 0; xTile <= xTileCount; ++xTile) {
                for (int yTile = 0; yTile <= yTileCount; ++yTile) {
                    int width = xTile == xTileCount ? xRemainder : 16;
                    int height = yTile == yTileCount ? yRemainder : 16;
                    int x = startX + xTile * 16;
                    int y = yStart - (yTile + 1) * 16;
                    if (width <= 0 || height <= 0) continue;
                    int maskTop = 16 - height;
                    int maskRight = 16 - width;
                    TankWidget.drawFluidTexture(transform.m_85850_().m_85861_(), x + this.xPos, y + this.yPos, fluidStillSprite, maskTop, maskRight, 100.0f);
                }
            }
        }
        if (this.drawOverlay) {
            RenderSystem.m_69465_();
            RenderSystem.m_157456_((int)0, (ResourceLocation)this.manager.gui.textureFile);
            TankWidget.setGLColorFromInt(0xFFFFFF);
            this.manager.gui.m_93228_(transform, startX + this.xPos, startY + this.yPos, this.overlayTexX, this.overlayTexY, 16, 60);
            RenderSystem.m_69482_();
        }
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    @Override
    public ToolTip getToolTip(int mouseX, int mouseY) {
        IFluidTank tank = this.getTank();
        if (!(tank instanceof StandardTank)) {
            return null;
        }
        StandardTank standardTank = (StandardTank)tank;
        return standardTank.getToolTip();
    }

    private static void setGLColorFromInt(int color) {
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        RenderSystem.m_157429_((float)red, (float)green, (float)blue, (float)1.0f);
    }

    private static void drawFluidTexture(Matrix4f matrix, float xCoord, float yCoord, TextureAtlasSprite textureSprite, int maskTop, int maskRight, float zLevel) {
        float uMin = textureSprite.m_118409_();
        float uMax = textureSprite.m_118410_();
        float vMin = textureSprite.m_118411_();
        float vMax = textureSprite.m_118412_();
        uMax -= (float)maskRight / 16.0f * (uMax - uMin);
        vMax -= (float)maskTop / 16.0f * (vMax - vMin);
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder buffer = tessellator.m_85915_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        buffer.m_85982_(matrix, xCoord, yCoord + 16.0f, zLevel).m_7421_(uMin, vMax).m_5752_();
        buffer.m_85982_(matrix, xCoord + 16.0f - (float)maskRight, yCoord + 16.0f, zLevel).m_7421_(uMax, vMax).m_5752_();
        buffer.m_85982_(matrix, xCoord + 16.0f - (float)maskRight, yCoord + (float)maskTop, zLevel).m_7421_(uMax, vMin).m_5752_();
        buffer.m_85982_(matrix, xCoord, yCoord + (float)maskTop, zLevel).m_7421_(uMin, vMin).m_5752_();
        tessellator.m_85914_();
    }

    @Override
    public void handleMouseClick(double mouseX, double mouseY, int mouseButton) {
        LocalPlayer player = this.manager.minecraft.f_91074_;
        ItemStack itemstack = player.f_36096_.m_142621_();
        if (itemstack.m_41619_()) {
            return;
        }
        Item held = itemstack.m_41720_();
        AbstractContainerMenu container = this.manager.gui.m_6262_();
        if (held instanceof IToolPipette && container instanceof IContainerLiquidTanks) {
            ((IContainerLiquidTanks)container).handlePipetteClickClient(this.slot, (Player)player);
        }
    }
}

