/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.inventory;

import forestry.api.core.ForestryError;
import forestry.api.core.IError;
import forestry.api.core.IErrorSource;
import forestry.api.genetics.IBreedingTracker;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.capability.IIndividualHandlerItem;
import forestry.apiculture.features.ApicultureItems;
import forestry.core.inventory.ItemInventory;
import forestry.core.utils.GeneticsUtil;
import java.util.Set;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelAccessor;

public class ItemInventoryAlyzer
extends ItemInventory
implements IErrorSource {
    public static final int SLOT_ENERGY = 0;
    public static final int SLOT_SPECIMEN = 1;
    public static final int SLOT_ANALYZE_1 = 2;
    public static final int SLOT_ANALYZE_2 = 3;
    public static final int SLOT_ANALYZE_3 = 4;
    public static final int SLOT_ANALYZE_4 = 5;
    public static final int SLOT_ANALYZE_5 = 6;

    public ItemInventoryAlyzer(Player player, ItemStack itemstack) {
        super(player, 7, itemstack);
    }

    public static boolean isAlyzingFuel(ItemStack itemstack) {
        if (itemstack.m_41619_()) {
            return false;
        }
        return ApicultureItems.HONEY_DROPS.itemEqual(itemstack) || ApicultureItems.HONEYDEW.itemEqual(itemstack);
    }

    @Override
    public boolean canSlotAccept(int slotIndex, ItemStack stack) {
        if (slotIndex == 0) {
            return ItemInventoryAlyzer.isAlyzingFuel(stack);
        }
        if (this.hasSpecimen() && this.m_8020_(slotIndex).m_41619_()) {
            return false;
        }
        stack = GeneticsUtil.convertToGeneticEquivalent(stack);
        return IIndividualHandlerItem.filter(stack, individual -> {
            if (slotIndex == 1) {
                return true;
            }
            return individual.isAnalyzed();
        });
    }

    @Override
    public void m_6836_(int index, ItemStack itemStack) {
        super.m_6836_(index, itemStack);
        if (index == 1) {
            this.analyzeSpecimen(itemStack);
        } else if (index == 0) {
            this.analyzeSpecimen(this.m_8020_(1));
        }
    }

    private void analyzeSpecimen(ItemStack specimen) {
        IIndividual individual;
        if (specimen.m_41619_()) {
            return;
        }
        ItemStack convertedSpecimen = GeneticsUtil.convertToGeneticEquivalent(specimen);
        if (!ItemStack.m_41728_((ItemStack)specimen, (ItemStack)convertedSpecimen)) {
            this.m_6836_(1, convertedSpecimen);
            specimen = convertedSpecimen;
        }
        if ((individual = IIndividualHandlerItem.getIndividual(specimen)) != null && !individual.isAnalyzed()) {
            if (!ItemInventoryAlyzer.isAlyzingFuel(this.m_8020_(0))) {
                return;
            }
            if (individual.analyze()) {
                IBreedingTracker breedingTracker = individual.getType().getBreedingTracker((LevelAccessor)this.player.f_19853_, this.player.m_36316_());
                breedingTracker.registerSpecies(individual.getSpecies());
                breedingTracker.registerSpecies(individual.getInactiveSpecies());
                individual.saveToStack(specimen);
                this.m_7407_(0, 1);
            }
        }
        this.m_6836_(2, specimen);
        this.m_6836_(1, ItemStack.f_41583_);
    }

    @Override
    public Set<IError> getErrors() {
        ItemStack specimen = this.getSpecimen();
        if (specimen.m_41619_()) {
            return Set.of(ForestryError.NO_SPECIMEN);
        }
        if (IIndividualHandlerItem.isIndividual(specimen) && !ItemInventoryAlyzer.isAlyzingFuel(this.m_8020_(0))) {
            return Set.of(ForestryError.NO_HONEY);
        }
        return Set.of();
    }

    public ItemStack getSpecimen() {
        for (int i = 1; i <= 6; ++i) {
            ItemStack itemStack = this.m_8020_(i);
            if (itemStack.m_41619_()) continue;
            return itemStack;
        }
        return ItemStack.f_41583_;
    }

    public boolean hasSpecimen() {
        return !this.getSpecimen().m_41619_();
    }

    @Override
    protected void onWriteNBT(CompoundTag nbt) {
        ItemStack energy = this.m_8020_(0);
        int amount = 0;
        if (!energy.m_41619_()) {
            amount = energy.m_41613_();
        }
        nbt.m_128405_("Charges", amount);
    }
}

