/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.loot;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import forestry.api.ForestryConstants;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.common.loot.LootTableIdCondition;
import org.jetbrains.annotations.NotNull;

public class ConditionLootModifier
extends LootModifier {
    public static final Codec<ConditionLootModifier> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)LOOT_CONDITIONS_CODEC.fieldOf("conditions").forGetter(lm -> lm.conditions), (App)ResourceLocation.f_135803_.fieldOf("table").forGetter(lm -> lm.tableLocation), (App)Codec.list((Codec)Codec.STRING).fieldOf("extensions").forGetter(o -> o.extensions)).apply((Applicative)instance, ConditionLootModifier::new));
    private final ResourceLocation tableLocation;
    private final List<String> extensions;
    private boolean operates = false;

    public ConditionLootModifier(ResourceLocation location, List<String> extensions) {
        super(new LootItemCondition[]{LootTableIdCondition.builder((ResourceLocation)location).m_6409_()});
        this.tableLocation = location;
        this.extensions = extensions;
    }

    private static LootItemCondition[] merge(LootItemCondition[] conditions, LootItemCondition condition) {
        LootItemCondition[] newArray = Arrays.copyOf(conditions, conditions.length + 1);
        newArray[conditions.length] = condition;
        return newArray;
    }

    private ConditionLootModifier(LootItemCondition[] conditions, ResourceLocation location, List<String> extensions) {
        super(ConditionLootModifier.merge(conditions, LootTableIdCondition.builder((ResourceLocation)location).m_6409_()));
        this.tableLocation = location;
        this.extensions = extensions;
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        if (this.operates) {
            return generatedLoot;
        }
        this.operates = true;
        for (String extension : this.extensions) {
            ResourceLocation location = ForestryConstants.forestry(this.tableLocation.m_135815_() + "/" + extension);
            LootTable table = context.m_78940_(location);
            if (table == LootTable.f_79105_) continue;
            generatedLoot.addAll((ObjectList)table.m_230922_(context));
        }
        this.operates = false;
        return generatedLoot;
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return CODEC;
    }
}

