/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.loot;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import forestry.api.IForestryApi;
import forestry.api.genetics.ILifeStage;
import forestry.api.genetics.ISpecies;
import forestry.api.genetics.ISpeciesType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class OrganismFunction
extends LootItemConditionalFunction {
    public static LootItemFunctionType type;
    private final ResourceLocation typeId;
    private final ResourceLocation speciesId;

    private OrganismFunction(LootItemCondition[] conditions, ResourceLocation typeId, ResourceLocation speciesId) {
        super(conditions);
        this.typeId = typeId;
        this.speciesId = speciesId;
    }

    public static LootItemConditionalFunction.Builder<?> fromDefinition(ISpeciesType<?, ?> type, ISpecies<?> species) {
        return OrganismFunction.fromId(type.id(), species.id());
    }

    public static LootItemConditionalFunction.Builder<?> fromId(ResourceLocation typeId, ResourceLocation speciesId) {
        return OrganismFunction.m_80683_(conditions -> new OrganismFunction((LootItemCondition[])conditions, typeId, speciesId));
    }

    protected ItemStack m_7372_(ItemStack stack, LootContext lootContext) {
        ISpeciesType<?, ?> speciesType = IForestryApi.INSTANCE.getGeneticManager().getSpeciesType(this.typeId);
        ILifeStage stage = speciesType.getLifeStage(stack);
        if (stage != null) {
            Object species = speciesType.getSpecies(this.speciesId);
            return species.createStack(stage);
        }
        return stack;
    }

    public LootItemFunctionType m_7162_() {
        return type;
    }

    public static class Serializer
    extends LootItemConditionalFunction.Serializer<OrganismFunction> {
        public void serialize(JsonObject object, OrganismFunction function, JsonSerializationContext context) {
            super.m_6170_(object, (LootItemConditionalFunction)function, context);
            object.addProperty("type_id", function.typeId.toString());
            object.addProperty("species_id", function.speciesId.toString());
        }

        public OrganismFunction deserialize(JsonObject object, JsonDeserializationContext jsonDeserializationContext, LootItemCondition[] conditions) {
            String typeId = GsonHelper.m_13906_((JsonObject)object, (String)"type_id");
            String speciesId = GsonHelper.m_13906_((JsonObject)object, (String)"species_id");
            return new OrganismFunction(conditions, new ResourceLocation(typeId), new ResourceLocation(speciesId));
        }
    }
}

