/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.models;

import com.google.common.collect.ImmutableList;
import com.mojang.math.Quaternion;
import com.mojang.math.Transformation;
import com.mojang.math.Vector3f;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.BakedModelWrapper;
import net.minecraftforge.client.model.data.ModelData;
import org.jetbrains.annotations.NotNull;

public class TRSRBakedModel
extends BakedModelWrapper<BakedModel> {
    protected final Transformation transformation;
    private final TRSROverride override;
    private final int faceOffset;

    public TRSRBakedModel(BakedModel original, float x, float y, float z, float scale) {
        this(original, x, y, z, 0.0f, 0.0f, 0.0f, scale, scale, scale);
    }

    public TRSRBakedModel(BakedModel original, float x, float y, float z, float rotX, float rotY, float rotZ, float scale) {
        this(original, x, y, z, rotX, rotY, rotZ, scale, scale, scale);
    }

    public TRSRBakedModel(BakedModel original, float x, float y, float z, float rotX, float rotY, float rotZ, float scaleX, float scaleY, float scaleZ) {
        this(original, new Transformation(new Vector3f(x, y, z), null, new Vector3f(scaleX, scaleY, scaleZ), new Quaternion(rotX, rotY, rotZ, false)));
    }

    public TRSRBakedModel(BakedModel original, Transformation transform) {
        super(original);
        this.transformation = transform.blockCenterToCorner();
        this.override = new TRSROverride(this);
        this.faceOffset = 0;
    }

    public TRSRBakedModel(BakedModel original, Direction facing) {
        super(original);
        this.override = new TRSROverride(this);
        this.faceOffset = 4 + Direction.NORTH.m_122416_() - facing.m_122416_();
        double r = Math.PI * (double)(360 - facing.m_122424_().m_122416_() * 90) / 180.0;
        this.transformation = new Transformation(null, null, null, new Quaternion(0.0f, (float)r, 0.0f, false)).blockCenterToCorner();
    }

    @NotNull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @NotNull RandomSource rand, @NotNull ModelData data, @Nullable RenderType renderType) {
        ImmutableList.Builder builder = ImmutableList.builder();
        if (!this.originalModel.m_7521_()) {
            try {
                if (side != null && side.m_122416_() > -1) {
                    side = Direction.m_122407_((int)((side.m_122416_() + this.faceOffset) % 4));
                }
                for (BakedQuad bakedQuad : this.originalModel.getQuads(state, side, rand, data, renderType)) {
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return builder.build();
    }

    public List<BakedQuad> m_213637_(@Nullable BlockState state, @Nullable Direction side, RandomSource rand) {
        return this.getQuads(state, side, rand, ModelData.EMPTY, null);
    }

    @Nonnull
    public ItemOverrides m_7343_() {
        return this.override;
    }

    private static class TRSROverride
    extends ItemOverrides {
        private final TRSRBakedModel model;

        public TRSROverride(TRSRBakedModel model) {
            this.model = model;
        }

        @Nonnull
        public BakedModel m_173464_(BakedModel originalModel, ItemStack stack, @Nullable ClientLevel world, @Nullable LivingEntity entity, int p_173469_) {
            BakedModel baked = this.model.originalModel.m_7343_().m_173464_(originalModel, stack, world, entity, p_173469_);
            if (baked == null) {
                baked = originalModel;
            }
            return new TRSRBakedModel(baked, this.model.transformation);
        }
    }
}

