/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.network.packets;

import forestry.api.modules.IForestryPacketClient;
import forestry.api.multiblock.IMultiblockComponent;
import forestry.api.multiblock.IMultiblockController;
import forestry.core.network.PacketIdClient;
import forestry.core.tiles.IActivatable;
import forestry.core.tiles.TileUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntity;

public record PacketActiveUpdate(BlockPos pos, boolean active) implements IForestryPacketClient
{
    public PacketActiveUpdate(IActivatable tile) {
        this(tile.getCoordinates(), tile.isActive());
    }

    @Override
    public ResourceLocation id() {
        return PacketIdClient.TILE_FORESTRY_ACTIVE;
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.m_130064_(this.pos);
        buffer.writeBoolean(this.active);
    }

    public static PacketActiveUpdate decode(FriendlyByteBuf buffer) {
        return new PacketActiveUpdate(buffer.m_130135_(), buffer.readBoolean());
    }

    public static void handle(PacketActiveUpdate msg, Player player) {
        IMultiblockController iMultiblockController;
        IMultiblockComponent component;
        BlockEntity tile = TileUtil.getTile((BlockGetter)player.f_19853_, msg.pos);
        if (tile instanceof IActivatable) {
            IActivatable activatable = (IActivatable)tile;
            activatable.setActive(msg.active);
        } else if (tile instanceof IMultiblockComponent && (component = (IMultiblockComponent)tile).getMultiblockLogic().isConnected() && (iMultiblockController = component.getMultiblockLogic().getController()) instanceof IActivatable) {
            IActivatable activatable = (IActivatable)((Object)iMultiblockController);
            activatable.setActive(msg.active);
        }
    }
}

