/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.network.packets;

import forestry.api.modules.IForestryPacketClient;
import forestry.core.circuits.ISocketable;
import forestry.core.network.PacketIdClient;
import forestry.core.tiles.TileUtil;
import forestry.core.utils.NetworkUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.BlockEntity;

public record PacketSocketUpdate(BlockPos pos, NonNullList<ItemStack> itemStacks) implements IForestryPacketClient
{
    public static <T extends BlockEntity> PacketSocketUpdate create(T tile) {
        BlockPos pos = tile.m_58899_();
        NonNullList itemStacks = NonNullList.m_122780_((int)((ISocketable)tile).getSocketCount(), (Object)ItemStack.f_41583_);
        for (int i = 0; i < ((ISocketable)tile).getSocketCount(); ++i) {
            itemStacks.set(i, (Object)((ISocketable)tile).getSocket(i));
        }
        return new PacketSocketUpdate(pos, (NonNullList<ItemStack>)itemStacks);
    }

    @Override
    public ResourceLocation id() {
        return PacketIdClient.SOCKET_UPDATE;
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.m_130064_(this.pos);
        NetworkUtil.writeItemStacks(buffer, this.itemStacks);
    }

    public static PacketSocketUpdate decode(FriendlyByteBuf buffer) {
        return new PacketSocketUpdate(buffer.m_130135_(), NetworkUtil.readItemStacks(buffer));
    }

    public static void handle(PacketSocketUpdate msg, Player player) {
        TileUtil.actOnTile((LevelReader)player.f_19853_, msg.pos, ISocketable.class, socketable -> {
            for (int i = 0; i < msg.itemStacks.size(); ++i) {
                socketable.setSocket(i, (ItemStack)msg.itemStacks.get(i));
            }
        });
    }
}

