/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.render;

import com.mojang.math.Vector3f;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.apiculture.hives.IHiveTile;
import forestry.api.genetics.IGenome;
import forestry.api.genetics.alleles.BeeChromosomes;
import forestry.apiculture.genetics.Bee;
import forestry.apiculture.genetics.effects.ThrottledBeeEffect;
import forestry.apiculture.particles.ApicultureParticles;
import forestry.apiculture.particles.BeeParticleData;
import forestry.apiculture.particles.BeeTargetParticleData;
import forestry.apiculture.particles.ParticleSnow;
import forestry.core.config.ForestryConfig;
import forestry.core.entities.ParticleIgnition;
import forestry.core.entities.ParticleSmoke;
import forestry.core.utils.VecUtil;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.ParticleStatus;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ParticleRender {
    private static final DustParticleOptions HONEY_DUST = new DustParticleOptions(new Vector3f(0.9f, 0.75f, 0.0f), 1.0f);

    public static boolean shouldSpawnParticle(Level world) {
        if (!((Boolean)ForestryConfig.CLIENT.showParticles.get()).booleanValue()) {
            return false;
        }
        Minecraft mc = Minecraft.m_91087_();
        ParticleStatus particleSetting = (ParticleStatus)mc.f_91066_.m_231929_().m_231551_();
        if (particleSetting == ParticleStatus.MINIMAL) {
            return world.f_46441_.m_188503_(10) == 0;
        }
        if (particleSetting == ParticleStatus.DECREASED) {
            return world.f_46441_.m_188503_(3) != 0;
        }
        return true;
    }

    public static void addBeeHiveFX(IBeeHousing housing, IGenome genome, List<BlockPos> flowerPositions) {
        List<LivingEntity> entitiesInRange;
        Level world1 = housing.getWorldObj();
        ClientLevel world = (ClientLevel)world1;
        if (!ParticleRender.shouldSpawnParticle((Level)world)) {
            return;
        }
        Vec3 particleStart = housing.getBeeFXCoordinates();
        BlockPos playerPosition = Minecraft.m_91087_().f_91074_.m_20183_();
        double playerDistanceSq = playerPosition.m_123331_(new Vec3i(particleStart.f_82479_, particleStart.f_82480_, particleStart.f_82481_));
        if ((double)world.f_46441_.m_188503_(1024) < playerDistanceSq) {
            return;
        }
        int color = genome.getActiveValue(BeeChromosomes.SPECIES).getOutline();
        int randomInt = world.f_46441_.m_188503_(100);
        if (housing instanceof IHiveTile && (((IHiveTile)((Object)housing)).isAngry() || randomInt >= 85) && !(entitiesInRange = ThrottledBeeEffect.getEntitiesInRange(genome, housing, LivingEntity.class)).isEmpty()) {
            LivingEntity entity = entitiesInRange.get(world.f_46441_.m_188503_(entitiesInRange.size()));
            world.m_7106_((ParticleOptions)new BeeTargetParticleData((Entity)entity, color), particleStart.f_82479_, particleStart.f_82480_, particleStart.f_82481_, 0.0, 0.0, 0.0);
            return;
        }
        if (randomInt < 75 && !flowerPositions.isEmpty()) {
            BlockPos destination = flowerPositions.get(world.f_46441_.m_188503_(flowerPositions.size()));
            world.m_7106_((ParticleOptions)new BeeParticleData((ParticleType<BeeParticleData>)((ParticleType)ApicultureParticles.BEE_ROUND_TRIP_PARTICLE.get()), destination, color), particleStart.f_82479_, particleStart.f_82480_, particleStart.f_82481_, 0.0, 0.0, 0.0);
        } else {
            Vec3i area = Bee.getModifiedArea(genome, housing);
            BlockPos offset = housing.getCoordinates().m_7918_(-area.m_123341_() / 2, -area.m_123342_() / 4, -area.m_123343_() / 2);
            BlockPos destination = VecUtil.getRandomPositionInArea(world.f_46441_, area).m_121955_((Vec3i)offset);
            world.m_7106_((ParticleOptions)new BeeParticleData((ParticleType<BeeParticleData>)((ParticleType)ApicultureParticles.BEE_EXPLORER_PARTICLE.get()), destination, color), particleStart.f_82479_, particleStart.f_82480_, particleStart.f_82481_, 0.0, 0.0, 0.0);
        }
    }

    public static void addEntityHoneyDustFX(Level world, double x, double y, double z) {
        if (!ParticleRender.shouldSpawnParticle(world)) {
            return;
        }
        world.m_7106_((ParticleOptions)HONEY_DUST, x, y, z, 0.0, 0.0, 0.0);
    }

    public static void addEntityExplodeFX(Level world, double x, double y, double z) {
        if (!ParticleRender.shouldSpawnParticle(world)) {
            return;
        }
        ParticleEngine effectRenderer = Minecraft.m_91087_().f_91061_;
        Particle Particle2 = effectRenderer.m_107370_((ParticleOptions)DustParticleOptions.f_123656_, x, y, z, 0.0, 0.0, 0.0);
        effectRenderer.m_107344_(Particle2);
    }

    public static void addEntitySnowFX(Level world, double x, double y, double z) {
        if (!ParticleRender.shouldSpawnParticle(world)) {
            return;
        }
        ParticleEngine effectRenderer = Minecraft.m_91087_().f_91061_;
        effectRenderer.m_107344_((Particle)new ParticleSnow((ClientLevel)world, x + world.f_46441_.m_188583_(), y, z + world.f_46441_.m_188583_()));
    }

    public static void addEntityIgnitionFX(ClientLevel world, double x, double y, double z) {
        if (!ParticleRender.shouldSpawnParticle((Level)world)) {
            return;
        }
        ParticleEngine effectRenderer = Minecraft.m_91087_().f_91061_;
        effectRenderer.m_107344_((Particle)new ParticleIgnition(world, x, y, z));
    }

    public static void addEntitySmokeFX(Level world, double x, double y, double z) {
        if (!ParticleRender.shouldSpawnParticle(world)) {
            return;
        }
        ParticleEngine effectRenderer = Minecraft.m_91087_().f_91061_;
        effectRenderer.m_107344_((Particle)new ParticleSmoke((ClientLevel)world, x, y, z));
    }

    public static void addEntityPotionFX(Level world, double x, double y, double z, int color) {
        if (!ParticleRender.shouldSpawnParticle(world)) {
            return;
        }
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        ParticleEngine effectRenderer = Minecraft.m_91087_().f_91061_;
        Particle particle = effectRenderer.m_107370_((ParticleOptions)DustParticleOptions.f_123656_, x, y, z, 0.0, 0.0, 0.0);
        if (particle != null) {
            particle.m_107253_(red, green, blue);
            effectRenderer.m_107344_(particle);
        }
    }

    public static void addPortalFx(Level world, BlockPos pos, RandomSource rand) {
        double zSpeed;
        double ySpeed;
        double xSpeed;
        double zPos;
        double yPos;
        if (!ParticleRender.shouldSpawnParticle(world)) {
            return;
        }
        int j = rand.m_188503_(2) * 2 - 1;
        int k = rand.m_188503_(2) * 2 - 1;
        ParticleEngine effectRenderer = Minecraft.m_91087_().f_91061_;
        double xPos = (double)pos.m_123341_() + 0.5 + 0.25 * (double)j;
        Particle particle = effectRenderer.m_107370_((ParticleOptions)DustParticleOptions.f_123656_, xPos, yPos = (double)((float)pos.m_123342_() + rand.m_188501_()), zPos = (double)pos.m_123343_() + 0.5 + 0.25 * (double)k, xSpeed = (double)(rand.m_188501_() * (float)j), ySpeed = ((double)rand.m_188501_() - 0.5) * 0.125, zSpeed = (double)(rand.m_188501_() * (float)k));
        if (particle != null) {
            effectRenderer.m_107344_(particle);
        }
    }
}

