/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import forestry.api.ForestryConstants;
import forestry.core.blocks.BlockBase;
import forestry.core.render.ForestryModelLayers;
import forestry.core.tiles.TileAnalyzer;
import forestry.core.utils.RenderUtil;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class RenderAnalyzer
implements BlockEntityRenderer<TileAnalyzer> {
    private static final String TOWER2 = "tower2";
    private static final String TOWER1 = "tower1";
    private static final String COVER = "cover";
    private static final String PEDESTAL = "pedestal";
    private static final ResourceLocation TEXTURE0 = ForestryConstants.forestry("textures/block/analyzer_pedestal.png");
    private static final ResourceLocation TEXTURE1 = ForestryConstants.forestry("textures/block/analyzer_tower1.png");
    private static final ResourceLocation TEXTURE2 = ForestryConstants.forestry("textures/block/analyzer_tower2.png");
    private final ItemRenderer itemRenderer;
    private final ModelPart pedestal;
    private final ModelPart cover;
    private final ModelPart tower1;
    private final ModelPart tower2;

    public RenderAnalyzer(BlockEntityRendererProvider.Context ctx) {
        this.itemRenderer = ctx.m_234447_();
        ModelPart root = ctx.m_173582_(ForestryModelLayers.ANALYZER_LAYER);
        this.pedestal = root.m_171324_(PEDESTAL);
        this.cover = root.m_171324_(COVER);
        this.tower1 = root.m_171324_(TOWER1);
        this.tower2 = root.m_171324_(TOWER2);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        partdefinition.m_171599_(PEDESTAL, CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(0.0f, 0.0f, 0.0f, 16.0f, 1.0f, 16.0f), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_(COVER, CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(0.0f, 0.0f, 0.0f, 16.0f, 1.0f, 16.0f), PartPose.m_171423_((float)16.0f, (float)16.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)((float)Math.PI)));
        partdefinition.m_171599_(TOWER1, CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(0.0f, 0.0f, 0.0f, 2.0f, 14.0f, 14.0f), PartPose.m_171419_((float)0.0f, (float)1.0f, (float)1.0f));
        partdefinition.m_171599_(TOWER2, CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(0.0f, 0.0f, 0.0f, 2.0f, 14.0f, 14.0f), PartPose.m_171419_((float)14.0f, (float)1.0f, (float)1.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)32);
    }

    public void render(TileAnalyzer analyzer, float partialTick, PoseStack stack, MultiBufferSource buffers, int light, int overlay) {
        stack.m_85836_();
        Direction facing = (Direction)analyzer.m_58900_().m_61143_(BlockBase.FACING);
        RenderUtil.rotateByHorizontalDirection(stack, facing);
        VertexConsumer buffer0 = buffers.m_6299_(RenderType.m_110452_((ResourceLocation)TEXTURE0));
        this.pedestal.m_104301_(stack, buffer0, light, overlay);
        this.cover.m_104301_(stack, buffer0, light, overlay);
        this.tower1.m_104301_(stack, buffers.m_6299_(RenderType.m_110452_((ResourceLocation)TEXTURE1)), light, overlay);
        this.tower2.m_104301_(stack, buffers.m_6299_(RenderType.m_110452_((ResourceLocation)TEXTURE2)), light, overlay);
        stack.m_85849_();
        ItemStack displayStack = analyzer.getIndividualOnDisplay();
        if (!displayStack.m_41619_()) {
            stack.m_85836_();
            stack.m_85837_(0.5, (double)0.2f, 0.5);
            RenderUtil.renderDisplayStack(stack, this.itemRenderer, displayStack, analyzer.m_58904_(), partialTick, buffers, light);
            stack.m_85849_();
        }
    }
}

