/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import forestry.api.ForestryConstants;
import forestry.core.render.ForestryModelLayers;
import forestry.core.tiles.TemperatureState;
import forestry.energy.blocks.EngineBlock;
import forestry.energy.tiles.EngineBlockEntity;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;

public class RenderEngine
implements BlockEntityRenderer<EngineBlockEntity> {
    private static final float[] ANGLE_MAP = new float[6];
    private final ResourceLocation[] textures;
    private final ModelPart boiler;
    private final ModelPart trunk;
    private final ModelPart piston;
    private final ModelPart extension;

    public RenderEngine(BlockEntityRendererProvider.Context ctx, String baseTexture) {
        ModelPart root = ctx.m_173582_(ForestryModelLayers.ENGINE_LAYER);
        this.boiler = root.m_171324_("boiler");
        this.trunk = root.m_171324_("trunk");
        this.piston = root.m_171324_("piston");
        this.extension = root.m_171324_("extension");
        this.textures = new ResourceLocation[]{ForestryConstants.forestry(baseTexture + "base.png"), ForestryConstants.forestry(baseTexture + "piston.png"), ForestryConstants.forestry(baseTexture + "extension.png"), ForestryConstants.forestry("textures/block/engine_trunk_highest.png"), ForestryConstants.forestry("textures/block/engine_trunk_higher.png"), ForestryConstants.forestry("textures/block/engine_trunk_high.png"), ForestryConstants.forestry("textures/block/engine_trunk_medium.png"), ForestryConstants.forestry("textures/block/engine_trunk_low.png")};
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition root = mesh.m_171576_();
        root.m_171599_("boiler", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(0.0f, 0.0f, 0.0f, 16.0f, 6.0f, 16.0f), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        root.m_171599_("trunk", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(0.0f, 0.0f, 0.0f, 8.0f, 12.0f, 8.0f), PartPose.m_171419_((float)4.0f, (float)4.0f, (float)4.0f));
        root.m_171599_("piston", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(0.0f, 0.0f, 0.0f, 12.0f, 4.0f, 12.0f), PartPose.m_171419_((float)2.0f, (float)6.0f, (float)2.0f));
        root.m_171599_("extension", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(0.0f, 0.0f, 0.0f, 10.0f, 2.0f, 10.0f), PartPose.m_171419_((float)3.0f, (float)5.0f, (float)3.0f));
        return LayerDefinition.m_171565_((MeshDefinition)mesh, (int)64, (int)32);
    }

    public void render(EngineBlockEntity engine, float partialTick, PoseStack stack, MultiBufferSource buffers, int light, int overlay) {
        stack.m_85836_();
        stack.m_85837_(0.5, 0.5, 0.5);
        Direction orientation = (Direction)engine.m_58900_().m_61143_(EngineBlock.VERTICAL_FACING);
        switch (orientation) {
            case EAST: 
            case WEST: 
            case DOWN: {
                stack.m_85845_(Vector3f.f_122227_.m_122270_(ANGLE_MAP[orientation.ordinal()]));
                break;
            }
            default: {
                stack.m_85845_(Vector3f.f_122223_.m_122270_(ANGLE_MAP[orientation.ordinal()]));
            }
        }
        stack.m_85837_(-0.5, -0.5, -0.5);
        this.boiler.m_104301_(stack, buffers.m_6299_(RenderType.m_110452_((ResourceLocation)this.textures[Textures.BASE.ordinal()])), light, overlay);
        float step = RenderEngine.getPistonStep(engine, partialTick);
        float tfactor = step / 16.0f;
        stack.m_85837_(0.0, (double)tfactor, 0.0);
        this.piston.m_104301_(stack, buffers.m_6299_(RenderType.m_110452_((ResourceLocation)this.textures[Textures.PISTON.ordinal()])), light, overlay);
        stack.m_85837_(0.0, (double)(-tfactor), 0.0);
        TemperatureState state = engine.m_58898_() ? engine.getTemperatureState() : TemperatureState.COOL;
        ResourceLocation texture = switch (state) {
            case TemperatureState.OVERHEATING -> this.textures[Textures.TRUNK_HIGHEST.ordinal()];
            case TemperatureState.RUNNING_HOT -> this.textures[Textures.TRUNK_HIGHER.ordinal()];
            case TemperatureState.OPERATING_TEMPERATURE -> this.textures[Textures.TRUNK_HIGH.ordinal()];
            case TemperatureState.WARMED_UP -> this.textures[Textures.TRUNK_MEDIUM.ordinal()];
            default -> this.textures[Textures.TRUNK_LOW.ordinal()];
        };
        this.trunk.m_104301_(stack, buffers.m_6299_(RenderType.m_110452_((ResourceLocation)texture)), light, overlay);
        float chamberf = 0.125f;
        if (step > 0.0f) {
            VertexConsumer buffer = buffers.m_6299_(RenderType.m_110452_((ResourceLocation)this.textures[Textures.EXTENSION.ordinal()]));
            int i = 0;
            while ((float)i <= step + 2.0f) {
                this.extension.m_104301_(stack, buffer, light, overlay);
                stack.m_85837_(0.0, (double)chamberf, 0.0);
                i += 2;
            }
        }
        stack.m_85849_();
    }

    private static float getPistonStep(EngineBlockEntity engine, float partialTick) {
        float progress;
        if (engine.m_58898_()) {
            progress = engine.progress;
            if (engine.stagePiston != 0) {
                float smoothing = engine.pistonSpeedServer * partialTick;
                progress += smoothing;
            }
        } else {
            progress = 0.25f;
        }
        if (progress > 0.5f) {
            return 6.0f - (progress - 0.5f) * 2.0f * 6.0f;
        }
        return progress * 2.0f * 6.0f;
    }

    static {
        RenderEngine.ANGLE_MAP[Direction.EAST.ordinal()] = -1.5707964f;
        RenderEngine.ANGLE_MAP[Direction.NORTH.ordinal()] = -1.5707964f;
        RenderEngine.ANGLE_MAP[Direction.WEST.ordinal()] = 1.5707964f;
        RenderEngine.ANGLE_MAP[Direction.SOUTH.ordinal()] = 1.5707964f;
        RenderEngine.ANGLE_MAP[Direction.UP.ordinal()] = 0.0f;
        RenderEngine.ANGLE_MAP[Direction.DOWN.ordinal()] = (float)Math.PI;
    }

    private static enum Textures {
        BASE,
        PISTON,
        EXTENSION,
        TRUNK_HIGHEST,
        TRUNK_HIGHER,
        TRUNK_HIGH,
        TRUNK_MEDIUM,
        TRUNK_LOW;

    }
}

