/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import forestry.api.ForestryConstants;
import forestry.core.blocks.BlockBase;
import forestry.core.render.EnumTankLevel;
import forestry.core.render.ForestryModelLayers;
import forestry.core.render.TankRenderInfo;
import forestry.core.tiles.IRenderableTile;
import forestry.core.tiles.TileBase;
import forestry.core.utils.RenderUtil;
import java.util.EnumMap;
import java.util.Locale;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;

public class RenderMachine
implements BlockEntityRenderer<TileBase> {
    private static final String BASE_FRONT = "basefront";
    private static final String BASE_BACK = "baseback";
    private static final String RESOURCE_TANK = "resourceTank";
    private static final String PRODUCT_TANK = "productTank";
    private final ModelPart basefront;
    private final ModelPart baseback;
    private final ModelPart resourceTank;
    private final ModelPart productTank;
    private final ResourceLocation textureBase;
    private final ResourceLocation textureResourceTank;
    private final ResourceLocation textureProductTank;
    private final EnumMap<EnumTankLevel, ResourceLocation> texturesTankLevels = new EnumMap(EnumTankLevel.class);

    public RenderMachine(BlockEntityRendererProvider.Context ctx, String baseTexture) {
        ModelPart root = ctx.m_173582_(ForestryModelLayers.MACHINE_LAYER);
        this.basefront = root.m_171324_(BASE_FRONT);
        this.baseback = root.m_171324_(BASE_BACK);
        this.resourceTank = root.m_171324_(RESOURCE_TANK);
        this.productTank = root.m_171324_(PRODUCT_TANK);
        this.textureBase = ForestryConstants.forestry(baseTexture + "base.png");
        this.textureProductTank = ForestryConstants.forestry(baseTexture + "tank_product_empty.png");
        this.textureResourceTank = ForestryConstants.forestry(baseTexture + "tank_resource_empty.png");
        for (EnumTankLevel tankLevel : EnumTankLevel.values()) {
            if (tankLevel == EnumTankLevel.EMPTY) continue;
            String tankLevelString = tankLevel.toString().toLowerCase(Locale.ENGLISH);
            this.texturesTankLevels.put(tankLevel, ForestryConstants.forestry("textures/block/machine_tank_" + tankLevelString + ".png"));
        }
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition root = mesh.m_171576_();
        root.m_171599_(BASE_FRONT, CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(0.0f, 0.0f, 0.0f, 16.0f, 4.0f, 16.0f), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        root.m_171599_(BASE_BACK, CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(0.0f, 0.0f, 0.0f, 16.0f, 4.0f, 16.0f), PartPose.m_171419_((float)0.0f, (float)12.0f, (float)0.0f));
        root.m_171599_(RESOURCE_TANK, CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(0.0f, 0.0f, 0.0f, 12.0f, 16.0f, 6.0f), PartPose.m_171419_((float)2.0f, (float)0.0f, (float)2.0f));
        root.m_171599_(PRODUCT_TANK, CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(0.0f, 0.0f, 0.0f, 12.0f, 16.0f, 6.0f), PartPose.m_171419_((float)2.0f, (float)0.0f, (float)8.0f));
        return LayerDefinition.m_171565_((MeshDefinition)mesh, (int)64, (int)32);
    }

    private void renderTank(PoseStack stack, ModelPart tankModel, MultiBufferSource buffers, ResourceLocation textureBase, TankRenderInfo renderInfo, int light, int overlay) {
        tankModel.m_104301_(stack, buffers.m_6299_(RenderType.m_110452_((ResourceLocation)textureBase)), light, overlay);
        ResourceLocation textureResourceTankLevel = this.texturesTankLevels.get((Object)renderInfo.getLevel());
        if (textureResourceTankLevel == null) {
            return;
        }
        int color = RenderUtil.getFluidColor(renderInfo.getFluidStack().getFluid());
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        tankModel.m_104306_(stack, buffers.m_6299_(RenderType.m_110452_((ResourceLocation)textureResourceTankLevel)), light, overlay, r, g, b, 1.0f);
    }

    public void render(TileBase machine, float partialTick, PoseStack stack, MultiBufferSource buffers, int light, int overlay) {
        stack.m_85836_();
        Direction orientation = (Direction)machine.m_58900_().m_61143_(BlockBase.FACING);
        RenderUtil.rotateByHorizontalDirection(stack, orientation);
        stack.m_85837_(0.5, 0.5, 0.5);
        stack.m_85845_(Vector3f.f_122223_.m_122270_(-1.5707964f));
        stack.m_85837_(-0.5, -0.5, -0.5);
        VertexConsumer base = buffers.m_6299_(RenderType.m_110452_((ResourceLocation)this.textureBase));
        this.basefront.m_104301_(stack, base, light, overlay);
        this.baseback.m_104301_(stack, base, light, overlay);
        stack.m_85837_(0.5, 0.5, 0.5);
        stack.m_85845_(Vector3f.f_122225_.m_122270_(-1.5707964f));
        stack.m_85837_(-0.5, -0.5, -0.5);
        IRenderableTile tile = (IRenderableTile)((Object)machine);
        TankRenderInfo resourceTankInfo = tile.getResourceTankInfo();
        TankRenderInfo productTankInfo = tile.getProductTankInfo();
        this.renderTank(stack, this.resourceTank, buffers, this.textureResourceTank, resourceTankInfo, light, overlay);
        this.renderTank(stack, this.productTank, buffers, this.textureProductTank, productTankInfo, light, overlay);
        stack.m_85849_();
    }
}

