/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import forestry.api.ForestryConstants;
import forestry.core.render.ForestryModelLayers;
import forestry.core.tiles.TileMill;
import forestry.core.utils.RenderUtil;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;

public class RenderMill
implements BlockEntityRenderer<TileMill> {
    private final ResourceLocation[] textures;
    private final ModelPart pedestal;
    private final ModelPart column;
    private final ModelPart extension;
    private final ModelPart blade;

    public RenderMill(BlockEntityRendererProvider.Context ctx, String baseTexture) {
        ModelPart root = ctx.m_173582_(ForestryModelLayers.MILL_LAYER);
        this.pedestal = root.m_171324_(Textures.PEDESTAL.name());
        this.column = root.m_171324_(Textures.CHARGE.name());
        this.extension = root.m_171324_(Textures.EXTENSION.name());
        this.blade = root.m_171324_(Textures.BLADE.name());
        this.textures = new ResourceLocation[11];
        this.textures[Textures.PEDESTAL.ordinal()] = ForestryConstants.forestry(baseTexture + "pedestal.png");
        this.textures[Textures.EXTENSION.ordinal()] = ForestryConstants.forestry(baseTexture + "extension.png");
        this.textures[Textures.BLADE.ordinal()] = ForestryConstants.forestry(baseTexture + "blade.png");
        for (int i = 0; i < 8; ++i) {
            this.textures[Textures.CHARGE.ordinal() + i] = ForestryConstants.forestry(baseTexture + "column_" + i + ".png");
        }
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        partdefinition.m_171599_(Textures.PEDESTAL.name(), CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(0.0f, 0.0f, 0.0f, 16.0f, 1.0f, 16.0f), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_(Textures.CHARGE.name(), CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(0.0f, 0.0f, 0.0f, 4.0f, 15.0f, 4.0f), PartPose.m_171419_((float)6.0f, (float)1.0f, (float)6.0f));
        partdefinition.m_171599_(Textures.EXTENSION.name(), CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(0.0f, 0.0f, 0.0f, 14.0f, 2.0f, 2.0f), PartPose.m_171419_((float)1.0f, (float)8.0f, (float)7.0f));
        partdefinition.m_171599_(Textures.BLADE.name(), CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(0.0f, 0.0f, 0.0f, 1.0f, 12.0f, 8.0f), PartPose.m_171419_((float)10.0f, (float)3.0f, (float)4.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)32);
    }

    public void render(TileMill mill, float partialTick, PoseStack stack, MultiBufferSource buffers, int light, int overlay) {
        stack.m_85836_();
        Direction orientation = Direction.SOUTH;
        RenderUtil.rotateByHorizontalDirection(stack, orientation);
        this.pedestal.m_104301_(stack, buffers.m_6299_(RenderType.m_110452_((ResourceLocation)this.textures[Textures.PEDESTAL.ordinal()])), light, overlay);
        this.column.m_104301_(stack, buffers.m_6299_(RenderType.m_110452_((ResourceLocation)this.textures[Textures.CHARGE.ordinal() + mill.charge])), light, overlay);
        this.extension.m_104301_(stack, buffers.m_6299_(RenderType.m_110452_((ResourceLocation)this.textures[Textures.EXTENSION.ordinal()])), light, overlay);
        float step = RenderMill.getBladeStep(mill, partialTick) / 16.0f;
        VertexConsumer buffer = buffers.m_6299_(RenderType.m_110452_((ResourceLocation)this.textures[Textures.BLADE.ordinal()]));
        stack.m_85836_();
        stack.m_85837_((double)step, 0.0, 0.0);
        this.blade.m_104301_(stack, buffer, light, overlay);
        stack.m_85849_();
        stack.m_85837_(1.0, 0.0, 1.0);
        stack.m_85845_(Vector3f.f_122225_.m_122270_((float)Math.PI));
        stack.m_85837_((double)step, 0.0, 0.0);
        this.blade.m_104301_(stack, buffer, light, overlay);
        stack.m_85849_();
    }

    private static float getBladeStep(TileMill mill, float partialTick) {
        float progress;
        if (mill.m_58898_()) {
            progress = mill.progress;
            if (mill.stage != 0) {
                float smoothing = mill.speed * partialTick;
                progress += smoothing;
            }
        } else {
            progress = 0.0f;
        }
        if (progress > 0.5f) {
            return 3.99f - (progress - 0.5f) * 2.0f * 3.99f;
        }
        return progress * 2.0f * 3.99f;
    }

    private static enum Textures {
        PEDESTAL,
        EXTENSION,
        BLADE,
        CHARGE;

    }
}

