/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.tiles;

import com.google.common.base.Preconditions;
import forestry.api.core.IErrorLogic;
import forestry.api.core.IErrorLogicSource;
import forestry.api.core.ILocationProvider;
import forestry.api.util.TickHelper;
import forestry.core.blocks.TileStreamUpdateTracker;
import forestry.core.errors.ErrorLogic;
import forestry.core.inventory.FakeInventoryAdapter;
import forestry.core.inventory.IInventoryAdapter;
import forestry.core.network.IStreamable;
import forestry.core.tiles.AdjacentTileCache;
import forestry.core.tiles.IFilterSlotDelegate;
import forestry.core.tiles.ITitled;
import forestry.core.utils.NBTUtilForestry;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public abstract class TileForestry
extends BlockEntity
implements IStreamable,
IErrorLogicSource,
WorldlyContainer,
IFilterSlotDelegate,
ITitled,
ILocationProvider,
MenuProvider {
    private final ErrorLogic errorHandler = new ErrorLogic();
    private final AdjacentTileCache tileCache = new AdjacentTileCache(this);
    private IInventoryAdapter inventory = FakeInventoryAdapter.INSTANCE;
    final TickHelper tickHelper;

    public TileForestry(BlockEntityType<?> tileEntityTypeIn, BlockPos pos, BlockState state) {
        super(tileEntityTypeIn, pos, state);
        this.tickHelper = new TickHelper(pos.hashCode());
    }

    protected AdjacentTileCache getTileCache() {
        return this.tileCache;
    }

    public void onNeighborTileChange(Level world, BlockPos pos, BlockPos neighbor) {
        this.tileCache.onNeighborChange();
    }

    public void m_7651_() {
        this.tileCache.purge();
        super.m_7651_();
    }

    public void m_6339_() {
        this.tileCache.purge();
        super.m_6339_();
    }

    protected void clientTick(Level level, BlockPos pos, BlockState state) {
    }

    protected void serverTick(Level level, BlockPos pos, BlockState state) {
    }

    protected final boolean updateOnInterval(int tickInterval) {
        return this.tickHelper.updateOnInterval(tickInterval);
    }

    public void m_142466_(CompoundTag data) {
        super.m_142466_(data);
        this.inventory.read(data);
    }

    public void m_183515_(CompoundTag data) {
        super.m_183515_(data);
        this.inventory.write(data);
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        return NBTUtilForestry.writeStreamableToNbt(this, tag);
    }

    public void handleUpdateTag(CompoundTag tag) {
        super.handleUpdateTag(tag);
        NBTUtilForestry.readStreamableFromNbt(this, tag);
    }

    protected final void sendNetworkUpdate() {
        TileStreamUpdateTracker.sendVisualUpdate(this);
    }

    @Override
    public void writeData(FriendlyByteBuf data) {
    }

    @Override
    public void readData(FriendlyByteBuf data) {
    }

    public void onDropContents(ServerLevel level) {
    }

    @Override
    @Nullable
    public Level getWorldObj() {
        return this.f_58857_;
    }

    protected boolean isRedstoneActivated() {
        return this.f_58857_.m_46755_(this.m_58899_()) > 0;
    }

    @Override
    public final IErrorLogic getErrorLogic() {
        return this.errorHandler;
    }

    @Override
    public Component getTitle() {
        return Component.m_237115_((String)this.m_58900_().m_60734_().m_7705_());
    }

    public IInventoryAdapter getInternalInventory() {
        return this.inventory;
    }

    protected final void setInternalInventory(IInventoryAdapter inv) {
        Preconditions.checkNotNull((Object)inv);
        this.inventory = inv;
    }

    public boolean m_7983_() {
        return this.getInternalInventory().m_7983_();
    }

    public final int m_6643_() {
        return this.getInternalInventory().m_6643_();
    }

    public final ItemStack m_8020_(int slotIndex) {
        return this.getInternalInventory().m_8020_(slotIndex);
    }

    public ItemStack m_7407_(int slotIndex, int amount) {
        return this.getInternalInventory().m_7407_(slotIndex, amount);
    }

    public ItemStack m_8016_(int slotIndex) {
        return this.getInternalInventory().m_8016_(slotIndex);
    }

    public void m_6836_(int slotIndex, ItemStack itemstack) {
        this.getInternalInventory().m_6836_(slotIndex, itemstack);
    }

    public final int m_6893_() {
        return this.getInternalInventory().m_6893_();
    }

    public final void m_5856_(Player player) {
        this.getInternalInventory().m_5856_(player);
    }

    public final void m_5785_(Player player) {
        this.getInternalInventory().m_5785_(player);
    }

    public final boolean m_6542_(Player player) {
        return this.getInternalInventory().m_6542_(player);
    }

    public final boolean m_7013_(int slotIndex, ItemStack itemStack) {
        return this.getInternalInventory().m_7013_(slotIndex, itemStack);
    }

    @Override
    public final boolean canSlotAccept(int slotIndex, ItemStack stack) {
        return this.getInternalInventory().canSlotAccept(slotIndex, stack);
    }

    @Override
    public boolean isLocked(int slotIndex) {
        return this.getInternalInventory().isLocked(slotIndex);
    }

    public int[] m_7071_(Direction side) {
        return this.getInternalInventory().m_7071_(side);
    }

    public final boolean m_7155_(int slotIndex, ItemStack itemStack, Direction side) {
        return this.getInternalInventory().m_7155_(slotIndex, itemStack, side);
    }

    public final boolean m_7157_(int slotIndex, ItemStack itemStack, Direction side) {
        return this.getInternalInventory().m_7157_(slotIndex, itemStack, side);
    }

    @Override
    public final BlockPos getCoordinates() {
        return this.m_58899_();
    }

    public void m_6211_() {
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (capability == ForgeCapabilities.ITEM_HANDLER) {
            if (facing != null) {
                return LazyOptional.of(() -> new SidedInvWrapper((WorldlyContainer)this.getInternalInventory(), facing)).cast();
            }
            return LazyOptional.of(() -> new InvWrapper((Container)this.getInternalInventory())).cast();
        }
        return super.getCapability(capability, facing);
    }

    public Component m_5446_() {
        return this.getTitle();
    }
}

