/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.tiles;

import forestry.api.core.ForestryError;
import forestry.api.core.IErrorLogic;
import forestry.core.circuits.ISpeedUpgradable;
import forestry.core.network.IStreamableGui;
import forestry.core.render.TankRenderInfo;
import forestry.core.tiles.IPowerHandler;
import forestry.core.tiles.IRenderableTile;
import forestry.core.tiles.TileBase;
import forestry.energy.EnergyHelper;
import forestry.energy.EnergyTransferMode;
import forestry.energy.ForestryEnergyStorage;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;

public abstract class TilePowered
extends TileBase
implements IRenderableTile,
ISpeedUpgradable,
IStreamableGui,
IPowerHandler {
    private static final int WORK_TICK_INTERVAL = 5;
    private final ForestryEnergyStorage energyStorage;
    private final LazyOptional<ForestryEnergyStorage> energyCap;
    private int workCounter;
    private int ticksPerWorkCycle;
    private int energyPerWorkCycle;
    protected float speedMultiplier = 1.0f;
    protected float powerMultiplier = 1.0f;
    private int noPowerTime = 0;

    protected TilePowered(BlockEntityType<?> type, BlockPos pos, BlockState state, int maxTransfer, int capacity) {
        super(type, pos, state);
        this.energyStorage = new ForestryEnergyStorage(maxTransfer, capacity, EnergyTransferMode.RECEIVE);
        this.energyCap = LazyOptional.of(() -> this.energyStorage);
        this.ticksPerWorkCycle = 4;
    }

    @Override
    public ForestryEnergyStorage getEnergyManager() {
        return this.energyStorage;
    }

    public int getWorkCounter() {
        return this.workCounter;
    }

    public void setTicksPerWorkCycle(int ticksPerWorkCycle) {
        this.ticksPerWorkCycle = ticksPerWorkCycle;
        this.workCounter = 0;
    }

    public int getTicksPerWorkCycle() {
        if (this.f_58857_.f_46443_) {
            return this.ticksPerWorkCycle;
        }
        return Math.round((float)this.ticksPerWorkCycle / this.speedMultiplier);
    }

    public void setEnergyPerWorkCycle(int energyPerWorkCycle) {
        this.energyPerWorkCycle = EnergyHelper.scaleForDifficulty(energyPerWorkCycle);
    }

    public int getEnergyPerWorkCycle() {
        return Math.round((float)this.energyPerWorkCycle * this.powerMultiplier);
    }

    public boolean hasResourcesMin(float percentage) {
        return false;
    }

    public boolean hasFuelMin(float percentage) {
        return false;
    }

    public abstract boolean hasWork();

    @Override
    public void serverTick(Level level, BlockPos pos, BlockState state) {
        super.serverTick(level, pos, state);
        if (!this.updateOnInterval(5)) {
            return;
        }
        IErrorLogic errorLogic = this.getErrorLogic();
        boolean disabled = this.isRedstoneActivated();
        errorLogic.setCondition(disabled, ForestryError.DISABLED_BY_REDSTONE);
        if (disabled) {
            return;
        }
        if (!this.hasWork()) {
            return;
        }
        int ticksPerWorkCycle = this.getTicksPerWorkCycle();
        if (this.workCounter < ticksPerWorkCycle) {
            int energyPerWorkCycle = this.getEnergyPerWorkCycle();
            boolean consumedEnergy = EnergyHelper.consumeEnergyToDoWork(this.energyStorage, ticksPerWorkCycle, energyPerWorkCycle);
            if (consumedEnergy) {
                errorLogic.setCondition(false, ForestryError.NO_POWER);
                ++this.workCounter;
                this.noPowerTime = 0;
            } else {
                ++this.noPowerTime;
                if (this.noPowerTime > 4) {
                    errorLogic.setCondition(true, ForestryError.NO_POWER);
                }
            }
        }
        if (this.workCounter >= ticksPerWorkCycle && this.workCycle()) {
            this.workCounter = 0;
        }
    }

    protected abstract boolean workCycle();

    public int getProgressScaled(int i) {
        int ticksPerWorkCycle = this.getTicksPerWorkCycle();
        if (ticksPerWorkCycle == 0) {
            return 0;
        }
        return this.workCounter * i / ticksPerWorkCycle;
    }

    @Override
    public void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        this.energyStorage.write(nbt);
    }

    @Override
    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.energyStorage.read(nbt);
    }

    @Override
    public void writeGuiData(FriendlyByteBuf data) {
        this.energyStorage.writeData(data);
        data.m_130130_(this.workCounter);
        data.m_130130_(this.getTicksPerWorkCycle());
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void readGuiData(FriendlyByteBuf data) {
        this.energyStorage.readData(data);
        this.workCounter = data.m_130242_();
        this.ticksPerWorkCycle = data.m_130242_();
    }

    @Override
    public void applySpeedUpgrade(double speedChange, double powerChange) {
        this.speedMultiplier = (float)((double)this.speedMultiplier + speedChange);
        this.powerMultiplier = (float)((double)this.powerMultiplier + powerChange);
        this.workCounter = 0;
    }

    @Override
    public TankRenderInfo getResourceTankInfo() {
        return TankRenderInfo.EMPTY;
    }

    @Override
    public TankRenderInfo getProductTankInfo() {
        return TankRenderInfo.EMPTY;
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (!this.f_58859_ && capability == ForgeCapabilities.ENERGY) {
            return this.energyCap.cast();
        }
        return super.getCapability(capability, facing);
    }
}

