/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.utils;

import forestry.core.circuits.ISocketable;
import forestry.core.inventory.ItemHandlerInventoryManipulator;
import forestry.core.inventory.StandardStackFilters;
import forestry.core.utils.ItemStackUtil;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.items.IItemHandler;

public abstract class InventoryUtil {
    public static boolean moveItemStack(IItemHandler source, IItemHandler dest) {
        ItemHandlerInventoryManipulator manipulator = new ItemHandlerInventoryManipulator(source);
        return manipulator.transferOneStack(dest, StandardStackFilters.ALL);
    }

    public static boolean moveItemStack(IItemHandler source, Iterable<IItemHandler> destinations) {
        for (IItemHandler dest : destinations) {
            if (!InventoryUtil.moveItemStack(source, dest)) continue;
            return true;
        }
        return false;
    }

    public static boolean consumeIngredients(Container inventory, List<Ingredient> ingredients, @Nullable Player player, boolean stowContainer, boolean craftingTools, boolean doRemove) {
        int[] consumeStacks = ItemStackUtil.createConsume(ingredients, inventory, craftingTools);
        if (doRemove && consumeStacks.length > 0) {
            return InventoryUtil.consumeItems(inventory, consumeStacks, player, stowContainer);
        }
        return consumeStacks.length > 0;
    }

    private static boolean consumeItems(Container inventory, int[] consumeStacks, @Nullable Player player, boolean stowContainer) {
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            int count = consumeStacks[i];
            if (count <= 0) continue;
            ItemStack oldStack = inventory.m_8020_(i);
            ItemStack removed = inventory.m_7407_(i, count);
            if (stowContainer && oldStack.m_41720_().hasCraftingRemainingItem(oldStack)) {
                InventoryUtil.stowContainerItem(removed, inventory, i, player);
            }
            if (count <= removed.m_41613_()) continue;
            return false;
        }
        return true;
    }

    public static boolean removeSets(Container inventory, int count, List<ItemStack> set, @Nullable Player player, boolean stowContainer, boolean craftingTools, boolean doRemove) {
        NonNullList<ItemStack> stock = InventoryUtil.getStacks(inventory);
        if (doRemove) {
            NonNullList<ItemStack> removed = InventoryUtil.removeSets(inventory, count, set, player, stowContainer, craftingTools);
            return removed != null && removed.size() >= count;
        }
        return ItemStackUtil.containsSets(set, stock, craftingTools) >= count;
    }

    @Nullable
    public static NonNullList<ItemStack> removeSets(Container inventory, int count, List<ItemStack> set, @Nullable Player player, boolean stowContainer, boolean craftingTools) {
        NonNullList removed = NonNullList.m_122780_((int)set.size(), (Object)ItemStack.f_41583_);
        NonNullList<ItemStack> stock = InventoryUtil.getStacks(inventory);
        if (ItemStackUtil.containsSets(set, stock, craftingTools) < count) {
            return null;
        }
        for (int i = 0; i < set.size(); ++i) {
            ItemStack itemStack = set.get(i);
            if (itemStack.m_41619_()) continue;
            ItemStack stackToRemove = itemStack.m_41777_();
            stackToRemove.m_41764_(stackToRemove.m_41613_() * count);
            ItemStack removedStack = InventoryUtil.removeStack(inventory, stackToRemove, player, stowContainer, false);
            if (removedStack.m_41619_()) {
                removedStack = InventoryUtil.removeStack(inventory, stackToRemove, player, stowContainer, craftingTools);
            }
            removed.set(i, (Object)removedStack);
        }
        return removed;
    }

    public static boolean deleteExactSet(Container inventory, NonNullList<ItemStack> required) {
        NonNullList<ItemStack> offered = InventoryUtil.getStacks(inventory);
        List<ItemStack> condensedRequired = ItemStackUtil.condenseStacks(required);
        List<ItemStack> condensedOffered = ItemStackUtil.condenseStacks(offered);
        for (ItemStack req : condensedRequired) {
            if (InventoryUtil.containsExactStack(req, condensedOffered)) continue;
            return false;
        }
        for (ItemStack itemStack : condensedRequired) {
            InventoryUtil.deleteExactStack(inventory, itemStack);
        }
        return true;
    }

    private static boolean containsExactStack(ItemStack req, List<ItemStack> condensedOffered) {
        for (ItemStack offer : condensedOffered) {
            if (offer.m_41613_() < req.m_41613_() || !ItemStackUtil.areItemStacksEqualIgnoreCount(req, offer)) continue;
            return true;
        }
        return false;
    }

    private static void deleteExactStack(Container inventory, ItemStack itemStack) {
        int count = itemStack.m_41613_();
        for (int j = 0; j < inventory.m_6643_(); ++j) {
            ItemStack removed;
            ItemStack stackInSlot = inventory.m_8020_(j);
            if (stackInSlot.m_41619_() || !ItemStackUtil.areItemStacksEqualIgnoreCount(itemStack, stackInSlot) || (count -= (removed = inventory.m_7407_(j, count)).m_41613_()) != 0) continue;
            return;
        }
    }

    private static ItemStack removeStack(Container inventory, ItemStack stackToRemove, @Nullable Player player, boolean stowContainer, boolean craftingTools) {
        for (int j = 0; j < inventory.m_6643_(); ++j) {
            ItemStack stackInSlot = inventory.m_8020_(j);
            if (stackInSlot.m_41619_() || !ItemStackUtil.isCraftingEquivalent(stackToRemove, stackInSlot, craftingTools)) continue;
            ItemStack removed = inventory.m_7407_(j, stackToRemove.m_41613_());
            stackToRemove.m_41774_(removed.m_41613_());
            if (stowContainer && stackToRemove.m_41720_().hasCraftingRemainingItem(stackToRemove)) {
                InventoryUtil.stowContainerItem(removed, inventory, j, player);
            }
            if (!stackToRemove.m_41619_()) continue;
            return removed;
        }
        return ItemStack.f_41583_;
    }

    public static boolean contains(Container inventory, List<ItemStack> query) {
        return InventoryUtil.contains(inventory, query, 0, inventory.m_6643_());
    }

    public static boolean contains(Container inventory, List<ItemStack> query, int startSlot, int slots) {
        NonNullList<ItemStack> stock = InventoryUtil.getStacks(inventory, startSlot, slots);
        return ItemStackUtil.containsSets(query, stock) > 0;
    }

    public static boolean isEmpty(Container inventory, int slotStart, int slotCount) {
        for (int i = slotStart; i < slotStart + slotCount; ++i) {
            if (inventory.m_8020_(i).m_41619_()) continue;
            return false;
        }
        return true;
    }

    public static NonNullList<ItemStack> getStacks(Container inventory) {
        NonNullList stacks = NonNullList.m_122780_((int)inventory.m_6643_(), (Object)ItemStack.f_41583_);
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            stacks.set(i, (Object)inventory.m_8020_(i));
        }
        return stacks;
    }

    public static NonNullList<ItemStack> getStacks(Container inventory, int slot1, int length) {
        NonNullList result = NonNullList.m_122780_((int)length, (Object)ItemStack.f_41583_);
        for (int i = slot1; i < slot1 + length; ++i) {
            result.set(i - slot1, (Object)inventory.m_8020_(i));
        }
        return result;
    }

    public static boolean tryAddStacksCopy(Container inventory, NonNullList<ItemStack> stacks, int startSlot, int slots, boolean all) {
        for (ItemStack stack : stacks) {
            if (stack == null || stack.m_41619_() || InventoryUtil.tryAddStack(inventory, stack.m_41777_(), startSlot, slots, all)) continue;
            return false;
        }
        return true;
    }

    public static boolean tryAddStack(Container inventory, ItemStack stack, boolean all) {
        return InventoryUtil.tryAddStack(inventory, stack, 0, inventory.m_6643_(), all, true);
    }

    public static boolean tryAddStack(Container inventory, ItemStack stack, boolean all, boolean doAdd) {
        return InventoryUtil.tryAddStack(inventory, stack, 0, inventory.m_6643_(), all, doAdd);
    }

    public static boolean tryAddStack(Container inventory, ItemStack stack, int startSlot, int slots, boolean all) {
        return InventoryUtil.tryAddStack(inventory, stack, startSlot, slots, all, true);
    }

    public static boolean tryAddStack(Container inventory, ItemStack stack, int startSlot, int slots, boolean all, boolean doAdd) {
        boolean success;
        int added = InventoryUtil.addStack(inventory, stack, startSlot, slots, false);
        boolean bl = all ? added == stack.m_41613_() : (success = added > 0);
        if (success && doAdd) {
            InventoryUtil.addStack(inventory, stack, startSlot, slots, true);
        }
        return success;
    }

    public static int addStack(Container inventory, ItemStack stack, boolean doAdd) {
        return InventoryUtil.addStack(inventory, stack, 0, inventory.m_6643_(), doAdd);
    }

    public static int addStack(Container inventory, ItemStack stack, int startSlot, int slots, boolean doAdd) {
        int i;
        if (stack.m_41619_()) {
            return 0;
        }
        int added = 0;
        for (i = startSlot; i < startSlot + slots; ++i) {
            ItemStack inventoryStack = inventory.m_8020_(i);
            if (inventoryStack.m_41619_() || !inventoryStack.m_41753_() || !inventoryStack.m_41656_(stack) || !ItemStack.m_41658_((ItemStack)inventoryStack, (ItemStack)stack)) continue;
            int remain = stack.m_41613_() - added;
            int space = inventoryStack.m_41741_() - inventoryStack.m_41613_();
            if (space <= 0) continue;
            if (space >= remain) {
                if (doAdd) {
                    inventoryStack.m_41769_(remain);
                }
                return stack.m_41613_();
            }
            if (doAdd) {
                inventoryStack.m_41764_(inventoryStack.m_41741_());
            }
            added += space;
        }
        if (added >= stack.m_41613_()) {
            return added;
        }
        for (i = startSlot; i < startSlot + slots; ++i) {
            if (!inventory.m_8020_(i).m_41619_()) continue;
            if (doAdd) {
                inventory.m_6836_(i, stack.m_41777_());
                inventory.m_8020_(i).m_41764_(stack.m_41613_() - added);
            }
            return stack.m_41613_();
        }
        return added;
    }

    public static boolean stowInInventory(ItemStack itemstack, Container inventory, boolean doAdd) {
        return InventoryUtil.stowInInventory(itemstack, inventory, doAdd, 0, inventory.m_6643_());
    }

    public static boolean stowInInventory(ItemStack itemstack, Container inventory, boolean doAdd, int slot1, int count) {
        boolean added = false;
        for (int i = slot1; i < slot1 + count; ++i) {
            ItemStack inventoryStack = inventory.m_8020_(i);
            if (inventoryStack.m_41619_()) {
                if (doAdd) {
                    inventory.m_6836_(i, itemstack.m_41777_());
                    itemstack.m_41764_(0);
                }
                return true;
            }
            if (inventoryStack.m_41613_() >= inventoryStack.m_41741_() || !inventoryStack.m_41656_(itemstack) || !ItemStack.m_41658_((ItemStack)inventoryStack, (ItemStack)itemstack)) continue;
            int space = inventoryStack.m_41741_() - inventoryStack.m_41613_();
            if (space > itemstack.m_41613_()) {
                if (doAdd) {
                    inventoryStack.m_41769_(itemstack.m_41613_());
                    itemstack.m_41764_(0);
                }
                return true;
            }
            if (doAdd) {
                inventoryStack.m_41764_(inventoryStack.m_41741_());
                itemstack.m_41774_(space);
            }
            added = true;
        }
        return added;
    }

    public static void stowContainerItem(ItemStack itemstack, Container stowing, int slotIndex, @Nullable Player player) {
        if (!itemstack.m_41720_().hasCraftingRemainingItem(itemstack)) {
            return;
        }
        ItemStack container = ForgeHooks.getCraftingRemainingItem((ItemStack)itemstack);
        if (!(container.m_41619_() || InventoryUtil.tryAddStack(stowing, container, slotIndex, 1, true) || InventoryUtil.tryAddStack(stowing, container, true) || player == null)) {
            player.m_36176_(container, true);
        }
    }

    public static void deepCopyInventoryContents(Container source, Container destination) {
        if (source.m_6643_() != destination.m_6643_()) {
            throw new IllegalArgumentException("Inventory sizes do not match. Source: " + source + ", Destination: " + destination);
        }
        for (int i = 0; i < source.m_6643_(); ++i) {
            ItemStack stack = source.m_8020_(i);
            if (!stack.m_41619_()) {
                stack = stack.m_41777_();
            }
            destination.m_6836_(i, stack);
        }
    }

    public static void dropSockets(ISocketable socketable, Level level, double x, double y, double z) {
        for (int slot = 0; slot < socketable.getSocketCount(); ++slot) {
            ItemStack itemstack = socketable.getSocket(slot);
            Containers.m_18992_((Level)level, (double)x, (double)y, (double)z, (ItemStack)itemstack);
            socketable.setSocket(slot, ItemStack.f_41583_);
        }
    }

    public static void dropSockets(ISocketable socketable, Level level, BlockPos pos) {
        InventoryUtil.dropSockets(socketable, level, pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
    }

    public static void readFromNBT(Container inventory, String name, CompoundTag compoundNBT) {
        if (!compoundNBT.m_128441_(name)) {
            return;
        }
        ListTag nbttaglist = compoundNBT.m_128437_(name, 10);
        for (int j = 0; j < nbttaglist.size(); ++j) {
            CompoundTag compoundNBT2 = nbttaglist.m_128728_(j);
            int index = compoundNBT2.m_128451_("Slot");
            inventory.m_6836_(index, ItemStack.m_41712_((CompoundTag)compoundNBT2));
        }
    }

    public static void writeToNBT(Container inventory, String name, CompoundTag compoundNBT) {
        ListTag nbttaglist = new ListTag();
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            if (inventory.m_8020_(i).m_41619_()) continue;
            CompoundTag compoundNBT2 = new CompoundTag();
            compoundNBT2.m_128405_("Slot", i);
            inventory.m_8020_(i).m_41739_(compoundNBT2);
            nbttaglist.add((Object)compoundNBT2);
        }
        compoundNBT.m_128365_(name, (Tag)nbttaglist);
    }
}

