/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.utils;

import forestry.api.core.tooltips.ToolTip;
import forestry.core.utils.Translator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemTooltipUtil {
    @OnlyIn(value=Dist.CLIENT)
    public static void addInformation(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        String unlocalizedName = stack.m_41778_();
        String tooltipKey = unlocalizedName + ".tooltip";
        if (Translator.canTranslateToLocal(tooltipKey)) {
            tooltip.add((Component)Component.m_237115_((String)tooltipKey).m_130940_(ChatFormatting.GRAY));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void addShiftInformation(ItemStack stack, @Nullable BlockGetter world, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.m_237110_((String)"for.gui.tooltip.tmi", (Object[])new Object[]{"< %s >"}).m_130944_(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.GRAY}));
    }

    @Nullable
    @OnlyIn(value=Dist.CLIENT)
    public static ToolTip getInformation(ItemStack stack) {
        Minecraft minecraft = Minecraft.m_91087_();
        boolean advancedTooltips = minecraft.f_91066_.f_92125_;
        return ItemTooltipUtil.getInformation(stack, (Player)minecraft.f_91074_, (TooltipFlag)(advancedTooltips ? TooltipFlag.Default.ADVANCED : TooltipFlag.Default.NORMAL));
    }

    @Nullable
    @OnlyIn(value=Dist.CLIENT)
    public static ToolTip getInformation(ItemStack stack, Player player, TooltipFlag flag) {
        if (stack.m_41619_()) {
            return null;
        }
        ToolTip toolTip = new ToolTip();
        toolTip.addAll(stack.m_41651_(player, flag));
        return toolTip;
    }
}

