/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.utils;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.artifact.versioning.VersionRange;

public abstract class ModUtil {
    public static boolean isModLoaded(String modname) {
        return ModList.get().isLoaded(modname);
    }

    public static boolean isModLoaded(String modname, @Nullable String versionRangeString) {
        Optional cont;
        if (!ModUtil.isModLoaded(modname)) {
            return false;
        }
        if (versionRangeString != null && (cont = ModList.get().getModContainerById(modname)).isPresent()) {
            ModContainer modContainer = (ModContainer)cont.get();
            ArtifactVersion modVersion = modContainer.getModInfo().getVersion();
            VersionRange range = VersionRange.createFromVersion((String)versionRangeString);
            DefaultArtifactVersion requiredVersion = new DefaultArtifactVersion(versionRangeString);
            return requiredVersion.compareTo(modVersion) > 0;
        }
        return true;
    }

    public static ResourceLocation getRegistryName(Fluid o) {
        return ForgeRegistries.FLUIDS.getKey((Object)o);
    }

    public static ResourceLocation getRegistryName(Block o) {
        return ForgeRegistries.BLOCKS.getKey((Object)o);
    }

    public static ResourceLocation getRegistryName(Item o) {
        return ForgeRegistries.ITEMS.getKey((Object)o);
    }

    public static ResourceLocation getRegistryName(ParticleType<?> o) {
        return ForgeRegistries.PARTICLE_TYPES.getKey(o);
    }

    public static ResourceLocation withSuffix(ResourceLocation id, String suffix) {
        return new ResourceLocation(id.m_135827_(), id.m_135815_() + suffix);
    }
}

