/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.utils;

import forestry.api.recipes.ICarpenterRecipe;
import forestry.api.recipes.ICentrifugeRecipe;
import forestry.api.recipes.IFabricatorRecipe;
import forestry.api.recipes.IFabricatorSmeltingRecipe;
import forestry.api.recipes.IFermenterRecipe;
import forestry.api.recipes.IHygroregulatorRecipe;
import forestry.api.recipes.IMoistenerRecipe;
import forestry.api.recipes.ISqueezerContainerRecipe;
import forestry.api.recipes.ISqueezerRecipe;
import forestry.api.recipes.IStillRecipe;
import forestry.core.ClientsideCode;
import forestry.core.fluids.FluidHelper;
import forestry.core.utils.ItemStackUtil;
import forestry.core.utils.ModUtil;
import forestry.factory.features.FactoryRecipeTypes;
import forestry.modules.features.FeatureRecipeType;
import forestry.worktable.inventory.WorktableCraftingContainer;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.server.ServerLifecycleHooks;

public class RecipeUtils {
    @Nullable
    public static RecipeManager getRecipeManager() {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        return server == null ? (FMLEnvironment.dist == Dist.CLIENT ? ClientsideCode.getRecipeManager() : null) : server.m_129894_();
    }

    public static Registry<Fluid> getFluidRegistry() {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        return server == null ? (FMLEnvironment.dist == Dist.CLIENT ? ClientsideCode.getFluidRegistry() : null) : server.m_206579_().m_175515_(Registry.f_122899_);
    }

    @Nullable
    public static <C extends Container, T extends Recipe<C>> Recipe<C> getRecipe(RecipeType<T> recipeType, ResourceLocation name, @Nullable Level world) {
        RecipeManager manager = RecipeUtils.getRecipeManager();
        if (manager == null) {
            return null;
        }
        return (Recipe)manager.m_44054_(recipeType).get(name);
    }

    public static <C extends Container, T extends Recipe<C>> List<T> getRecipes(RecipeType<T> recipeType, C inventory, @Nullable Level world) {
        RecipeManager manager = RecipeUtils.getRecipeManager();
        if (manager == null || world == null) {
            return Collections.emptyList();
        }
        return manager.m_44056_(recipeType, inventory, world);
    }

    public static List<CraftingRecipe> findMatchingRecipes(CraftingContainer inventory, Level level) {
        return level.m_7465_().m_44056_(RecipeType.f_44107_, (Container)inventory, level);
    }

    @Nullable
    public static WorktableCraftingContainer getUsedMatrix(WorktableCraftingContainer originalMatrix, NonNullList<ItemStack> availableItems, Level level, CraftingRecipe recipe) {
        ItemStack output;
        if (!recipe.m_5818_((Container)originalMatrix, level)) {
            return null;
        }
        ItemStack expectedOutput = recipe.m_5874_((Container)originalMatrix);
        if (expectedOutput.m_41619_()) {
            return null;
        }
        WorktableCraftingContainer usedMatrix = new WorktableCraftingContainer();
        List<ItemStack> stockCopy = ItemStackUtil.condenseStacks(availableItems);
        for (int slot = 0; slot < originalMatrix.m_6643_(); ++slot) {
            ItemStack stack = originalMatrix.m_8020_(slot);
            if (stack.m_41619_()) continue;
            ItemStack equivalent = RecipeUtils.getCraftingEquivalent(stockCopy, originalMatrix, slot, level, recipe, expectedOutput);
            if (equivalent.m_41619_()) {
                return null;
            }
            usedMatrix.m_6836_(slot, equivalent);
        }
        if (recipe.m_5818_((Container)usedMatrix, level) && ItemStack.m_41728_((ItemStack)(output = recipe.m_5874_((Container)usedMatrix)), (ItemStack)expectedOutput)) {
            return usedMatrix;
        }
        return null;
    }

    private static ItemStack getCraftingEquivalent(List<ItemStack> stockCopy, WorktableCraftingContainer originalMatrix, int slot, Level level, CraftingRecipe recipe, ItemStack expectedOutput) {
        ItemStack originalStack = originalMatrix.m_8020_(slot);
        for (ItemStack stockStack : stockCopy) {
            ItemStack output;
            if (stockStack.m_41619_()) continue;
            ItemStack singleStockStack = stockStack.m_41777_();
            singleStockStack.m_41764_(1);
            originalMatrix.m_6836_(slot, singleStockStack);
            if (!recipe.m_5818_((Container)originalMatrix, level) || !ItemStack.m_41728_((ItemStack)(output = recipe.m_5874_((Container)originalMatrix)), (ItemStack)expectedOutput)) continue;
            originalMatrix.m_6836_(slot, originalStack);
            return stockStack.m_41620_(1);
        }
        originalMatrix.m_6836_(slot, originalStack);
        return ItemStack.f_41583_;
    }

    @Nullable
    public static IHygroregulatorRecipe getHygroRegulatorRecipe(RecipeManager manager, FluidStack input) {
        return RecipeUtils.getMatchingRecipe(manager, FactoryRecipeTypes.HYGROREGULATOR, recipe -> recipe.getInputFluid().isFluidEqual(input));
    }

    @Nullable
    public static IFermenterRecipe getFermenterRecipe(RecipeManager manager, ItemStack inputItem, FluidStack inputFluid) {
        return RecipeUtils.getMatchingRecipe(manager, FactoryRecipeTypes.FERMENTER, recipe -> recipe.matches(inputItem, inputFluid));
    }

    public static boolean isFermenterInput(RecipeManager manager, ItemStack stack) {
        return RecipeUtils.getRecipes(manager, FactoryRecipeTypes.FERMENTER).anyMatch(recipe -> recipe.getInputItem().test(stack));
    }

    @Nullable
    public static ICarpenterRecipe getCarpenterRecipe(RecipeManager manager, FluidStack fluid, ItemStack boxStack, Container craftingInventory, Level level) {
        return RecipeUtils.getMatchingRecipe(manager, FactoryRecipeTypes.CARPENTER, recipe -> recipe.matches(fluid, boxStack, craftingInventory, level));
    }

    public static boolean isCarpenterBox(RecipeManager manager, ItemStack stack) {
        return RecipeUtils.getMatchingRecipe(manager, FactoryRecipeTypes.CARPENTER, recipe -> recipe.getBox().test(stack)) != null;
    }

    public static boolean isSqueezerIngredient(RecipeManager manager, ItemStack stack) {
        return RecipeUtils.getRecipes(manager, FactoryRecipeTypes.SQUEEZER).anyMatch(recipe -> {
            for (Ingredient ingredient : recipe.getInputs()) {
                if (!ingredient.test(stack)) continue;
                return true;
            }
            return false;
        });
    }

    @Nullable
    public static ISqueezerContainerRecipe getSqueezerContainerRecipe(RecipeManager manager, ItemStack stack) {
        if (!FluidHelper.isDrainableFilledContainer(stack)) {
            return null;
        }
        return RecipeUtils.getMatchingRecipe(manager, FactoryRecipeTypes.SQUEEZER_CONTAINER, recipe -> recipe.getEmptyContainer().m_41656_(stack));
    }

    @Nullable
    public static ICentrifugeRecipe getCentrifugeRecipe(RecipeManager manager, ItemStack stack) {
        return RecipeUtils.getMatchingRecipe(manager, FactoryRecipeTypes.CENTRIFUGE, recipe -> recipe.getInput().test(stack));
    }

    @Nullable
    public static IFabricatorSmeltingRecipe getFabricatorMeltingRecipe(RecipeManager manager, ItemStack stack) {
        return RecipeUtils.getMatchingRecipe(manager, FactoryRecipeTypes.FABRICATOR_SMELTING, recipe -> recipe.getInput().test(stack));
    }

    @Nullable
    public static IFabricatorRecipe getFabricatorRecipe(RecipeManager manager, Level level, FluidStack liquid, ItemStack stack, Container inventory) {
        return RecipeUtils.getMatchingRecipe(manager, FactoryRecipeTypes.FABRICATOR, recipe -> recipe.matches(level, liquid, stack, inventory));
    }

    public static boolean isFabricatorPlan(RecipeManager manager, ItemStack stack) {
        return RecipeUtils.getMatchingRecipe(manager, FactoryRecipeTypes.FABRICATOR, recipe -> recipe.getPlan().test(stack)) != null;
    }

    @Nullable
    public static IMoistenerRecipe getMoistenerRecipe(RecipeManager manager, ItemStack stack) {
        return RecipeUtils.getMatchingRecipe(manager, FactoryRecipeTypes.MOISTENER, recipe -> recipe.getInput().test(stack));
    }

    @Nullable
    public static ISqueezerRecipe getSqueezerRecipe(RecipeManager manager, List<ItemStack> inputs) {
        return RecipeUtils.getMatchingRecipe(manager, FactoryRecipeTypes.SQUEEZER, recipe -> ItemStackUtil.createConsume(recipe.getInputs(), inputs.size(), inputs::get, false).length > 0);
    }

    @Nullable
    public static IStillRecipe getStillRecipe(RecipeManager manager, FluidStack input) {
        return RecipeUtils.getMatchingRecipe(manager, FactoryRecipeTypes.STILL, recipe -> recipe.matches(input));
    }

    @Nullable
    private static <R extends Recipe<C>, C extends Container> R getMatchingRecipe(RecipeManager manager, FeatureRecipeType<R> type, Predicate<R> matcher) {
        return (R)((Recipe)RecipeUtils.getRecipes(manager, type).filter(matcher).findFirst().orElse(null));
    }

    public static <R extends Recipe<C>, C extends Container> Stream<R> getRecipes(RecipeManager manager, FeatureRecipeType<R> type) {
        return manager.m_44054_(type.type()).values().stream();
    }

    public static <R extends Recipe<C>, C extends Container> Set<ResourceLocation> getTargetFluidsFromStacks(RecipeManager manager, RecipeType<R> type, Function<R, FluidStack> targetFluid) {
        return RecipeUtils.getTargetFluids(manager, type, recipe -> ((FluidStack)targetFluid.apply(recipe)).getFluid());
    }

    public static <R extends Recipe<C>, C extends Container> Set<ResourceLocation> getTargetFluids(RecipeManager manager, RecipeType<R> type, Function<R, Fluid> targetFluid) {
        return manager.m_44054_(type).values().stream().map(value -> ModUtil.getRegistryName((Fluid)targetFluid.apply(value))).collect(Collectors.toSet());
    }

    public static <R extends Recipe<C>, C extends Container> R getRecipeByOutput(FeatureRecipeType<R> recipeType, ItemStack output) {
        return (R)RecipeUtils.getRecipes(RecipeUtils.getRecipeManager(), recipeType).filter(recipe -> recipe.m_8043_().m_41656_(output)).findFirst().orElseThrow(() -> new IllegalStateException("Couldn't find a recipe with output: " + output));
    }
}

