/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.utils;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import forestry.core.fluids.ForestryFluids;
import java.awt.Color;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidType;

public class RenderUtil {
    public static void rotateByHorizontalDirection(PoseStack stack, Direction facing) {
        if (facing != Direction.SOUTH) {
            stack.m_85837_(0.5, 0.5, 0.5);
            stack.m_85845_(Vector3f.f_122225_.m_122240_(-facing.m_122435_()));
            stack.m_85837_(-0.5, -0.5, -0.5);
        }
    }

    public static void renderDisplayStack(PoseStack stack, ItemRenderer itemRenderer, ItemStack displayStack, Level level, float partialTick, MultiBufferSource buffers, int light) {
        BakedModel itemModel = itemRenderer.m_174264_(displayStack, level, null, 1);
        boolean isGui3d = itemModel.m_7539_();
        float smoothTick = (float)((int)level.m_46467_()) + partialTick;
        float f1 = Mth.m_14031_((float)(smoothTick / 10.0f)) * 0.1f + 0.1f;
        float f2 = itemModel.m_7442_().m_111808_((ItemTransforms.TransformType)ItemTransforms.TransformType.GROUND).f_111757_.m_122260_();
        stack.m_85837_(0.0, (double)(f1 + 0.25f * f2), 0.0);
        stack.m_85845_(Vector3f.f_122225_.m_122270_(smoothTick / 20.0f));
        itemRenderer.m_115143_(displayStack, ItemTransforms.TransformType.GROUND, false, stack, buffers, light, OverlayTexture.f_118083_, itemModel);
        if (!isGui3d) {
            stack.m_85837_(0.0, 0.0, 0.09375);
        }
    }

    public static int getFluidColor(Fluid fluid) {
        FluidType attributes = fluid.getFluidType();
        int color = IClientFluidTypeExtensions.of((FluidType)attributes).getTintColor();
        ForestryFluids definition = ForestryFluids.getFluidDefinition(fluid);
        if (color < 0) {
            color = Color.BLUE.getRGB();
            if (definition != null) {
                color = definition.getParticleColor().getRGB();
            }
        }
        return color;
    }

    public static Color getRainbowColor(long time, float partialTicks) {
        return Color.getHSBColor((180.0f * Mth.m_14031_((float)(((float)time + partialTicks) / 30.0f)) - 180.0f) / 360.0f, 0.5f, 0.8f);
    }
}

