/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.utils;

import com.google.common.collect.AbstractIterator;
import java.util.Comparator;
import java.util.Iterator;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.Heightmap;

public final class VecUtil {
    public static final Comparator<BlockPos> TOP_DOWN_COMPARATOR = (a, b) -> Integer.compare(b.m_123342_(), a.m_123342_());

    public static BlockPos getRandomPositionInArea(RandomSource random, Vec3i area) {
        int x = random.m_188503_(area.m_123341_());
        int y = random.m_188503_(area.m_123342_());
        int z = random.m_188503_(area.m_123343_());
        return new BlockPos(x, y, z);
    }

    public static BlockPos sum(Vec3i ... vectors) {
        int x = 0;
        int y = 0;
        int z = 0;
        for (Vec3i vec : vectors) {
            x += vec.m_123341_();
            y += vec.m_123342_();
            z += vec.m_123343_();
        }
        return new BlockPos(x, y, z);
    }

    public static BlockPos scale(Vec3i vec, float factor) {
        return new BlockPos((double)((float)vec.m_123341_() * factor), (double)((float)vec.m_123342_() * factor), (double)((float)vec.m_123343_() * factor));
    }

    public static Direction direction(Vec3i a, Vec3i b) {
        int z;
        int y;
        int x = Math.abs(a.m_123341_() - b.m_123341_());
        int max = Math.max(x, Math.max(y = Math.abs(a.m_123342_() - b.m_123342_()), z = Math.abs(a.m_123343_() - b.m_123343_())));
        if (max == x) {
            return Direction.EAST;
        }
        if (max == z) {
            return Direction.SOUTH;
        }
        return Direction.UP;
    }

    public static Iterator<BlockPos.MutableBlockPos> getAllInBoxFromCenterMutable(Level level, BlockPos from, BlockPos center, BlockPos to) {
        int minX = Math.min(from.m_123341_(), to.m_123341_());
        int minY = Math.min(from.m_123342_(), to.m_123342_());
        int minZ = Math.min(from.m_123343_(), to.m_123343_());
        int maxX = Math.max(from.m_123341_(), to.m_123341_());
        int maxY = Math.max(from.m_123342_(), to.m_123342_());
        int maxZ = Math.max(from.m_123343_(), to.m_123343_());
        return new MutableBlockPosSpiralIterator(level, center, minX, minY, minZ, maxX, maxY, maxZ);
    }

    private static class MutableBlockPosSpiralIterator
    extends AbstractIterator<BlockPos.MutableBlockPos> {
        private final Level level;
        private final BlockPos center;
        private final int minX;
        private final int minY;
        private final int minZ;
        private final int maxX;
        private final int maxY;
        private final int maxZ;
        private int spiralLayer;
        private final int maxSpiralLayers;
        private int direction;
        @Nullable
        private BlockPos.MutableBlockPos theBlockPos;

        public MutableBlockPosSpiralIterator(Level level, BlockPos center, int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
            this.level = level;
            this.center = center;
            this.minX = minX;
            this.minY = minY;
            this.minZ = minZ;
            this.maxX = maxX;
            this.maxY = maxY;
            this.maxZ = maxZ;
            int xDiameter = maxX - minX;
            int zDiameter = maxZ - minZ;
            this.maxSpiralLayers = Math.max(xDiameter, zDiameter) / 2;
            this.spiralLayer = 1;
        }

        @Nullable
        protected BlockPos.MutableBlockPos computeNext() {
            BlockPos.MutableBlockPos pos;
            while ((pos = this.nextPos()) != null && (pos.m_123341_() > this.maxX || pos.m_123342_() > this.maxY || pos.m_123343_() > this.maxZ || pos.m_123341_() < this.minX || pos.m_123342_() < this.minY || pos.m_123343_() < this.minZ)) {
            }
            return pos;
        }

        @Nullable
        protected BlockPos.MutableBlockPos nextPos() {
            if (this.theBlockPos == null) {
                this.theBlockPos = new BlockPos.MutableBlockPos(this.center.m_123341_(), this.maxY, this.center.m_123343_());
                int y = Math.min(this.maxY, this.level.m_6924_(Heightmap.Types.OCEAN_FLOOR_WG, this.theBlockPos.m_123341_(), this.theBlockPos.m_123343_()) - 1);
                this.theBlockPos.m_142448_(y);
                return this.theBlockPos;
            }
            if (this.spiralLayer > this.maxSpiralLayers) {
                return (BlockPos.MutableBlockPos)this.endOfData();
            }
            int x = this.theBlockPos.m_123341_();
            int y = this.theBlockPos.m_123342_();
            int z = this.theBlockPos.m_123343_();
            if (y > this.minY && y > 0) {
                --y;
            } else {
                switch (this.direction) {
                    case 0: {
                        if (++x != this.center.m_123341_() + this.spiralLayer) break;
                        ++this.direction;
                        break;
                    }
                    case 1: {
                        if (++z != this.center.m_123343_() + this.spiralLayer) break;
                        ++this.direction;
                        break;
                    }
                    case 2: {
                        if (--x != this.center.m_123341_() - this.spiralLayer) break;
                        ++this.direction;
                        break;
                    }
                    case 3: {
                        if (--z != this.center.m_123343_() - this.spiralLayer) break;
                        this.direction = 0;
                        ++this.spiralLayer;
                    }
                }
                this.theBlockPos.m_122178_(x, y, z);
                y = Math.min(this.maxY, this.level.m_6924_(Heightmap.Types.WORLD_SURFACE, x, z) - 1);
            }
            return this.theBlockPos.m_122178_(x, y, z);
        }
    }
}

