/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.utils.datastructures;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import javax.annotation.Nullable;
import net.minecraft.util.RandomSource;

public class WeightedCollection<T> {
    private final NavigableMap<Double, T> map = new TreeMap<Double, T>();
    private double total = 0.0;

    public void put(double weight, T value) {
        Preconditions.checkArgument((weight > 0.0 ? 1 : 0) != 0);
        this.total += weight;
        this.map.put(this.total, value);
    }

    @Nullable
    public T getRandom(RandomSource random) {
        double value = random.m_188500_() * this.total;
        Map.Entry<Double, T> higherEntry = this.map.higherEntry(value);
        if (higherEntry == null) {
            return null;
        }
        return higherEntry.getValue();
    }

    public Set<Map.Entry<Double, T>> entrySet() {
        return Collections.unmodifiableSet(this.map.entrySet());
    }
}

