/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.worldgen;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import forestry.api.IForestryApi;
import forestry.api.apiculture.genetics.BeeLifeStage;
import forestry.api.apiculture.genetics.IBee;
import forestry.api.apiculture.genetics.IBeeSpecies;
import forestry.api.apiculture.genetics.IBeeSpeciesType;
import forestry.api.apiculture.hives.IHiveManager;
import forestry.api.climate.ClimateState;
import forestry.api.genetics.ClimateHelper;
import forestry.api.genetics.IGenome;
import forestry.api.genetics.alleles.BeeChromosomes;
import forestry.api.genetics.alleles.IAllele;
import forestry.api.genetics.alleles.IChromosome;
import forestry.apiculture.VillageHive;
import forestry.apiculture.blocks.BlockTypeApiculture;
import forestry.apiculture.features.ApicultureBlocks;
import forestry.apiculture.features.ApicultureFeatures;
import forestry.apiculture.features.ApicultureItems;
import forestry.apiculture.tiles.TileApiary;
import forestry.core.tiles.TileUtil;
import forestry.core.utils.SpeciesUtil;
import forestry.modules.features.FeatureBlock;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.properties.StructureMode;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.pools.SinglePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElementType;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockIgnoreProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class ApiaristPoolElement
extends SinglePoolElement {
    public static final Codec<ApiaristPoolElement> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ApiaristPoolElement.m_210465_(), (App)ApiaristPoolElement.m_210462_()).apply((Applicative)instance, ApiaristPoolElement::new));

    public ApiaristPoolElement(Either<ResourceLocation, StructureTemplate> template, Holder<StructureProcessorList> processors) {
        super(template, processors, StructureTemplatePool.Projection.RIGID);
    }

    public void m_227329_(LevelAccessor level, StructureTemplate.StructureBlockInfo info, BlockPos pos, Rotation rotation, RandomSource random, BoundingBox box) {
        String marker;
        if (info.f_74677_ != null && StructureMode.valueOf((String)info.f_74677_.m_128461_("mode")) == StructureMode.DATA && "apiary".equals(marker = info.f_74677_.m_128461_("metadata"))) {
            ApiaristPoolElement.replaceWithApiary(level, info, random);
        }
    }

    protected StructurePlaceSettings m_207169_(Rotation rotation, BoundingBox bounds, boolean keepJigsaws) {
        return super.m_207169_(rotation, bounds, keepJigsaws).m_74397_((StructureProcessor)BlockIgnoreProcessor.f_74046_);
    }

    private static void replaceWithApiary(LevelAccessor level, StructureTemplate.StructureBlockInfo info, RandomSource random) {
        BlockPos markerPos = info.f_74675_;
        level.m_7471_(markerPos, false);
        level.m_7731_(markerPos, ((FeatureBlock)ApicultureBlocks.BASE.get(BlockTypeApiculture.APIARY)).defaultState(), 3);
        TileUtil.actOnTile((LevelReader)level, markerPos, TileApiary.class, apiary -> {
            ItemStack queen = ApiaristPoolElement.chooseRandomVillageQueen(level, markerPos, random);
            apiary.m_6836_(0, queen);
            for (int i = 0; i < 3; ++i) {
                ItemStack frame = ApicultureItems.FRAME_PROVEN.stack();
                int maxDamage = frame.m_41776_();
                frame.m_41721_(random.m_216332_(maxDamage / 4, maxDamage - maxDamage / 4));
                apiary.m_6836_(9 + i, frame);
            }
        });
    }

    private static ItemStack chooseRandomVillageQueen(LevelAccessor level, BlockPos markerPos, RandomSource random) {
        IHiveManager manager = IForestryApi.INSTANCE.getHiveManager();
        boolean rarePool = random.m_188503_(4) == 0;
        ImmutableList<VillageHive> pool = rarePool ? manager.getRareVillageHives() : manager.getCommonVillageHives();
        IBeeSpeciesType type = (IBeeSpeciesType)SpeciesUtil.BEE_TYPE.get();
        ClimateState biomeState = IForestryApi.INSTANCE.getClimateManager().getBiomeState((LevelReader)level, markerPos);
        ArrayList<Pair<IBeeSpecies, Map<IChromosome<?>, IAllele>>> candidates = ApiaristPoolElement.getCandidates(type, pool, biomeState);
        if (rarePool && candidates.isEmpty()) {
            candidates = ApiaristPoolElement.getCandidates(type, manager.getCommonVillageHives(), biomeState);
        }
        if (candidates.isEmpty()) {
            ImmutableList<VillageHive> commons = manager.getCommonVillageHives();
            VillageHive hive = (VillageHive)commons.get(random.m_188503_(commons.size()));
            IBeeSpecies species = (IBeeSpecies)type.getSpecies(hive.speciesId());
            return ApiaristPoolElement.createQueen(species, hive.alleles());
        }
        Pair<IBeeSpecies, Map<IChromosome<?>, IAllele>> candidate = candidates.get(random.m_188503_(candidates.size()));
        return ApiaristPoolElement.createQueen((IBeeSpecies)candidate.getFirst(), (Map)candidate.getSecond());
    }

    private static ArrayList<Pair<IBeeSpecies, Map<IChromosome<?>, IAllele>>> getCandidates(IBeeSpeciesType type, List<VillageHive> pool, ClimateState biomeState) {
        ArrayList candidates = new ArrayList();
        for (VillageHive hive : pool) {
            IBeeSpecies species = (IBeeSpecies)type.getSpecies(hive.speciesId());
            IGenome defaultGenome = species.getDefaultGenome();
            if (!ClimateHelper.isWithinLimits(biomeState.temperature(), species.getTemperature(), defaultGenome.getActiveValue(BeeChromosomes.TEMPERATURE_TOLERANCE)) || !ClimateHelper.isWithinLimits(biomeState.humidity(), species.getHumidity(), defaultGenome.getActiveValue(BeeChromosomes.HUMIDITY_TOLERANCE))) continue;
            candidates.add(Pair.of((Object)species, hive.alleles()));
        }
        return candidates;
    }

    private static ItemStack createQueen(IBeeSpecies species, Map<IChromosome<?>, IAllele> extraAlleles) {
        IBee bee = (IBee)species.createIndividual(extraAlleles);
        bee.setMate(bee.getGenome());
        return bee.createStack(BeeLifeStage.QUEEN);
    }

    public StructurePoolElementType<?> m_207234_() {
        return (StructurePoolElementType)ApicultureFeatures.APIARIST_POOL_ELEMENT_TYPE.get();
    }

    public String toString() {
        return "ApiaristPoolElement[" + this.f_210411_ + "]";
    }
}

