/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.worldgen;

import forestry.api.arboriculture.ITreeGenData;
import forestry.arboriculture.worldgen.ITreeBlockType;
import forestry.arboriculture.worldgen.TreeBlockType;
import forestry.arboriculture.worldgen.TreeContour;
import forestry.core.utils.VecUtil;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.DirectionalPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class FeatureHelper {
    public static boolean addBlock(LevelAccessor world, BlockPos pos, ITreeBlockType type, EnumReplaceMode replaceMode) {
        return FeatureHelper.addBlock(world, pos, type, replaceMode, TreeContour.EMPTY);
    }

    public static boolean addBlock(LevelAccessor world, BlockPos pos, ITreeBlockType type, EnumReplaceMode replaceMode, TreeContour contour) {
        if (!world.m_46805_(pos)) {
            return false;
        }
        BlockState blockState = world.m_8055_(pos);
        if (replaceMode.canReplace(blockState, world, pos)) {
            type.setBlock(world, pos);
            contour.addLeaf(pos);
            return true;
        }
        return false;
    }

    public static void generateCylinderFromTreeStartPos(LevelAccessor world, ITreeBlockType block, BlockPos startPos, int girth, float radius, int height, EnumReplaceMode replace, TreeContour contour) {
        FeatureHelper.generateCylinderFromPos(world, block, startPos.m_7918_(girth / 2, 0, girth / 2), radius, height, replace, contour);
    }

    public static void generateCylinderFromPos(LevelAccessor world, ITreeBlockType block, BlockPos center, float radius, int height, EnumReplaceMode replace, TreeContour contour) {
        BlockPos start = new BlockPos((double)((float)center.m_123341_() - radius), (double)center.m_123342_(), (double)((float)center.m_123343_() - radius));
        int x = 0;
        while ((float)x < radius * 2.0f + 1.0f) {
            for (int y = height - 1; y >= 0; --y) {
                int z = 0;
                while ((float)z < radius * 2.0f + 1.0f) {
                    Vec3i treeCenter;
                    BlockPos position = start.m_7918_(x, y, z);
                    if (position.m_123331_(treeCenter = new Vec3i(center.m_123341_(), position.m_123342_(), center.m_123343_())) <= (double)(radius * radius) + 0.01) {
                        Direction direction = VecUtil.direction((Vec3i)position, treeCenter);
                        block.setDirection(direction);
                        if (FeatureHelper.addBlock(world, position, block, replace)) {
                            contour.addLeaf(position);
                        }
                    }
                    ++z;
                }
            }
            ++x;
        }
    }

    public static void generateCircleFromTreeStartPos(LevelAccessor world, RandomSource rand, BlockPos startPos, int girth, float radius, int width, int height, ITreeBlockType block, float chance, EnumReplaceMode replace, TreeContour contour) {
        FeatureHelper.generateCircle(world, rand, startPos.m_7918_(girth / 2, 0, girth / 2), radius, width, height, block, chance, replace, contour);
    }

    public static void generateCircle(LevelAccessor world, RandomSource rand, BlockPos center, float radius, int width, int height, ITreeBlockType block, float chance, EnumReplaceMode replace, TreeContour contour) {
        Vec3i start = new Vec3i((double)((float)center.m_123341_() - radius), (double)center.m_123342_(), (double)((float)center.m_123343_() - radius));
        Vec3i area = new Vec3i((double)(radius * 2.0f + 1.0f), (double)height, (double)(radius * 2.0f + 1.0f));
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        for (int x = start.m_123341_(); x < start.m_123341_() + area.m_123341_(); ++x) {
            for (int y = start.m_123342_() + area.m_123342_() - 1; y >= start.m_123342_(); --y) {
                for (int z = start.m_123343_(); z < start.m_123343_() + area.m_123343_(); ++z) {
                    double distance;
                    if (rand.m_188501_() > chance || !(((double)(radius - (float)width) - 0.01) * ((double)(radius - (float)width) - 0.01) < (distance = mutablePos.m_122178_(x, y, z).m_203202_((double)center.m_123341_(), (double)y, (double)center.m_123343_()))) || !(distance <= ((double)radius + 0.01) * ((double)radius + 0.01)) || !FeatureHelper.addBlock(world, (BlockPos)mutablePos, block, replace)) continue;
                    contour.addLeaf((BlockPos)mutablePos);
                }
            }
        }
    }

    public static void generateSphereFromTreeStartPos(LevelAccessor world, BlockPos startPos, int girth, int radius, ITreeBlockType block, EnumReplaceMode replace, TreeContour contour) {
        FeatureHelper.generateSphere(world, startPos.m_7918_(girth / 2, 0, girth / 2), radius, block, replace, contour);
    }

    public static void generateSphere(LevelAccessor world, BlockPos center, int radius, ITreeBlockType block, EnumReplaceMode replace, TreeContour contour) {
        Vec3i start = new Vec3i(center.m_123341_() - radius, center.m_123342_() - radius, center.m_123343_() - radius);
        Vec3i area = new Vec3i(radius * 2 + 1, radius * 2 + 1, radius * 2 + 1);
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        for (int x = start.m_123341_(); x < start.m_123341_() + area.m_123341_(); ++x) {
            for (int y = start.m_123342_() + area.m_123342_() - 1; y >= start.m_123342_(); --y) {
                for (int z = start.m_123343_(); z < start.m_123343_() + area.m_123343_(); ++z) {
                    if (!center.m_123314_((Vec3i)mutablePos.m_122178_(x, y, z), (double)radius + 0.01) || !FeatureHelper.addBlock(world, (BlockPos)mutablePos, block, replace)) continue;
                    contour.addLeaf((BlockPos)mutablePos);
                }
            }
        }
    }

    public static Set<BlockPos> generateTreeTrunk(LevelAccessor world, RandomSource rand, ITreeBlockType wood, BlockPos startPos, int height, int girth, int yStart, float vinesChance, @Nullable Direction leanDirection, float leanScale) {
        HashSet<BlockPos> treeTops = new HashSet<BlockPos>();
        int leanStartY = (int)Math.floor((float)height * 0.33f);
        int prevXOffset = 0;
        int prevZOffset = 0;
        int leanX = 0;
        int leanZ = 0;
        if (leanDirection != null) {
            leanX = leanDirection.m_122429_();
            leanZ = leanDirection.m_122431_();
        }
        for (int x = 0; x < girth; ++x) {
            for (int z = 0; z < girth; ++z) {
                for (int y = height - 1; y >= yStart; --y) {
                    float lean = y < leanStartY ? 0.0f : leanScale * (float)(y - leanStartY) / (float)(height - leanStartY);
                    int xOffset = (int)Math.floor((float)leanX * lean);
                    int zOffset = (int)Math.floor((float)leanZ * lean);
                    if (xOffset != prevXOffset || zOffset != prevZOffset) {
                        prevXOffset = xOffset;
                        prevZOffset = zOffset;
                        if (y > 0) {
                            if (leanDirection != null) {
                                wood.setDirection(leanDirection);
                            }
                            FeatureHelper.addBlock(world, startPos.m_7918_(x + xOffset, y - 1, z + zOffset), wood, EnumReplaceMode.ALL);
                            wood.setDirection(Direction.UP);
                        }
                    }
                    BlockPos pos = startPos.m_7918_(x + xOffset, y, z + zOffset);
                    FeatureHelper.addBlock(world, pos, wood, EnumReplaceMode.ALL);
                    FeatureHelper.addVines(world, rand, pos, vinesChance);
                    if (y + 1 != height) continue;
                    treeTops.add(pos);
                }
            }
        }
        return treeTops;
    }

    protected static void addVines(LevelAccessor world, RandomSource rand, BlockPos pos, float chance) {
        BlockState blockState;
        if (chance <= 0.0f) {
            return;
        }
        if (rand.m_188501_() < chance) {
            blockState = (BlockState)Blocks.f_50191_.m_49966_().m_61124_((Property)VineBlock.f_57835_, (Comparable)Boolean.valueOf(true));
            FeatureHelper.addBlock(world, pos.m_122024_(), new TreeBlockType(blockState), EnumReplaceMode.AIR);
        }
        if (rand.m_188501_() < chance) {
            blockState = (BlockState)Blocks.f_50191_.m_49966_().m_61124_((Property)VineBlock.f_57837_, (Comparable)Boolean.valueOf(true));
            FeatureHelper.addBlock(world, pos.m_122029_(), new TreeBlockType(blockState), EnumReplaceMode.AIR);
        }
        if (rand.m_188501_() < chance) {
            blockState = (BlockState)Blocks.f_50191_.m_49966_().m_61124_((Property)VineBlock.f_57836_, (Comparable)Boolean.valueOf(true));
            FeatureHelper.addBlock(world, pos.m_122012_(), new TreeBlockType(blockState), EnumReplaceMode.AIR);
        }
        if (rand.m_188501_() < chance) {
            blockState = (BlockState)Blocks.f_50191_.m_49966_().m_61124_((Property)VineBlock.f_57834_, (Comparable)Boolean.valueOf(true));
            FeatureHelper.addBlock(world, pos.m_122019_(), new TreeBlockType(blockState), EnumReplaceMode.AIR);
        }
    }

    public static void generatePods(ITreeGenData tree, LevelAccessor world, RandomSource rand, BlockPos startPos, int height, int minHeight, int girth, EnumReplaceMode replaceMode) {
        for (int y = height - 1; y >= minHeight; --y) {
            for (int x = 0; x < girth; ++x) {
                for (int z = 0; z < girth; ++z) {
                    if (x > 0 && x < girth && z > 0 && z < girth) continue;
                    FeatureHelper.trySpawnFruitBlock(tree, world, rand, startPos.m_7918_(x + 1, y, z), replaceMode);
                    FeatureHelper.trySpawnFruitBlock(tree, world, rand, startPos.m_7918_(x - 1, y, z), replaceMode);
                    FeatureHelper.trySpawnFruitBlock(tree, world, rand, startPos.m_7918_(x, y, z + 1), replaceMode);
                    FeatureHelper.trySpawnFruitBlock(tree, world, rand, startPos.m_7918_(x, y, z - 1), replaceMode);
                }
            }
        }
    }

    private static void trySpawnFruitBlock(ITreeGenData tree, LevelAccessor world, RandomSource rand, BlockPos pos, EnumReplaceMode replaceMode) {
        BlockState blockState = world.m_8055_(pos);
        if (replaceMode.canReplace(blockState, world, pos)) {
            tree.trySpawnFruitBlock(world, rand, pos);
        }
    }

    public static void generateSupportStems(ITreeBlockType wood, LevelAccessor world, RandomSource rand, BlockPos startPos, int height, int girth, float chance, float maxHeight) {
        int min = -1;
        for (int x = -1; x <= girth; ++x) {
            for (int z = -1; z <= girth; ++z) {
                if (x == -1 && z == -1 || x == girth && z == girth || x == -1 && z == girth || x == girth && z == -1) continue;
                int stemHeight = rand.m_188503_(Math.round((float)height * maxHeight));
                if (!(rand.m_188501_() < chance)) continue;
                for (int y = 0; y < stemHeight; ++y) {
                    FeatureHelper.addBlock(world, startPos.m_7918_(x, y, z), wood, EnumReplaceMode.SOFT);
                }
            }
        }
    }

    public static Set<BlockPos> generateBranches(LevelAccessor world, RandomSource rand, ITreeBlockType wood, BlockPos startPos, int girth, float spreadY, float spreadXZ, int radius, int count, float chance) {
        HashSet<BlockPos> branchEnds = new HashSet<BlockPos>();
        if (radius < 1) {
            radius = 1;
        }
        for (Direction branchDirection : Direction.Plane.HORIZONTAL) {
            wood.setDirection(branchDirection);
            BlockPos branchStart = startPos;
            int offsetX = branchDirection.m_122429_();
            int offsetZ = branchDirection.m_122431_();
            if (offsetX > 0) {
                branchStart = branchStart.m_7918_(girth - 1, 0, 0);
            }
            if (offsetZ > 0) {
                branchStart = branchStart.m_7918_(0, 0, girth - 1);
            }
            for (int i = 0; i < count; ++i) {
                if (rand.m_188501_() > chance) continue;
                int y = 0;
                int x = 0;
                int z = 0;
                BlockPos branchEnd = null;
                for (int r = 0; r < radius; ++r) {
                    if (rand.m_188501_() < spreadY) {
                        ++y;
                        wood.setDirection(Direction.UP);
                    } else if (rand.m_188501_() < spreadXZ) {
                        if (branchDirection.m_122434_() == Direction.Axis.Z) {
                            x = rand.m_188499_() ? ++x : --x;
                            wood.setDirection(Direction.EAST);
                        } else if (branchDirection.m_122434_() == Direction.Axis.X) {
                            z = rand.m_188499_() ? ++z : --z;
                            wood.setDirection(Direction.SOUTH);
                        }
                    } else {
                        x += offsetX;
                        z += offsetZ;
                        wood.setDirection(branchDirection);
                    }
                    BlockPos pos = branchStart.m_7918_(x, y, z);
                    if (!FeatureHelper.addBlock(world, pos, wood, EnumReplaceMode.SOFT)) break;
                    branchEnd = pos;
                }
                if (branchEnd == null) continue;
                branchEnds.add(branchEnd);
            }
        }
        return branchEnds;
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum EnumReplaceMode {
        AIR{

            @Override
            public boolean canReplace(BlockState blockState, LevelAccessor world, BlockPos pos) {
                return world.m_46859_(pos);
            }
        }
        ,
        ALL{

            @Override
            public boolean canReplace(BlockState blockState, LevelAccessor world, BlockPos pos) {
                return true;
            }
        }
        ,
        SOFT{

            @Override
            public boolean canReplace(BlockState blockState, LevelAccessor world, BlockPos pos) {
                if (world instanceof Level) {
                    DirectionalPlaceContext context = new DirectionalPlaceContext((Level)world, pos, Direction.DOWN, ItemStack.f_41583_, Direction.UP);
                    return blockState.m_60629_((BlockPlaceContext)context);
                }
                return blockState.m_60767_().m_76336_();
            }
        };


        public abstract boolean canReplace(BlockState var1, LevelAccessor var2, BlockPos var3);
    }

    public static class DirectionHelper {
        public static final Direction[] VALUES = new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.EAST, Direction.WEST};

        public static Direction getRandom(RandomSource random) {
            return VALUES[random.m_188503_(VALUES.length)];
        }

        public static Direction getRandomOther(RandomSource random, Direction direction) {
            List<Direction> directions = Arrays.asList(VALUES);
            directions.remove(direction);
            int size = directions.size();
            return directions.toArray(new Direction[size])[random.m_188503_(size)];
        }
    }
}

