/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.worldgen;

import com.mojang.serialization.Codec;
import forestry.api.IForestryApi;
import forestry.api.apiculture.hives.IHive;
import forestry.api.climate.IClimateManager;
import forestry.api.core.HumidityType;
import forestry.api.core.TemperatureType;
import forestry.apiculture.features.ApicultureFeatures;
import forestry.arboriculture.features.ArboricultureFeatures;
import net.minecraft.core.Holder;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.common.world.ModifiableBiomeInfo;

public class ForestryBiomeModifier
implements BiomeModifier {
    public static final Codec<ForestryBiomeModifier> CODEC = Codec.unit(ForestryBiomeModifier::new);

    public void modify(Holder<Biome> biome, BiomeModifier.Phase phase, ModifiableBiomeInfo.BiomeInfo.Builder builder) {
        if (phase == BiomeModifier.Phase.ADD) {
            IClimateManager climates = IForestryApi.INSTANCE.getClimateManager();
            TemperatureType temperature = climates.getTemperature(biome);
            HumidityType humidity = climates.getHumidity(biome);
            builder.getGenerationSettings().m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, (Holder)ArboricultureFeatures.PLACED_TREE_DECORATOR.getHolder().get());
            for (IHive hive : IForestryApi.INSTANCE.getHiveManager().getHives()) {
                if (!hive.isGoodBiome(biome) || !hive.isGoodTemperature(temperature) || !hive.isGoodHumidity(humidity)) continue;
                builder.getGenerationSettings().m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, (Holder)ApicultureFeatures.PLACED_HIVE_DECORATOR.getHolder().get());
                return;
            }
        }
    }

    public Codec<? extends BiomeModifier> codec() {
        return CODEC;
    }
}

