/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.worldgen;

import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import forestry.api.ForestryConstants;
import forestry.core.worldgen.ApiaristPoolElement;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.core.Holder;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.data.worldgen.ProcessorLists;
import net.minecraft.data.worldgen.VillagePools;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class VillagerJigsaw {
    public static void init() {
        VillagePools.m_127306_();
        VillagerJigsaw.addVillagerHouse("plains", 15);
        VillagerJigsaw.addVillagerHouse("snowy", 15);
        VillagerJigsaw.addVillagerHouse("savanna", 15);
        VillagerJigsaw.addVillagerHouse("desert", 15);
        VillagerJigsaw.addVillagerHouse("taiga", 15);
    }

    private static void addVillagerHouse(String biome, int weight) {
        VillagerJigsaw.addToJigsawPattern(new ResourceLocation("village/" + biome + "/houses"), (StructurePoolElement)new ApiaristPoolElement((Either<ResourceLocation, StructureTemplate>)Either.left((Object)ForestryConstants.forestry("village/apiarist_house_" + biome + "_1")), (Holder<StructureProcessorList>)ProcessorLists.f_127198_), weight);
    }

    public static void addToJigsawPattern(ResourceLocation pool, StructurePoolElement newPiece, int weight) {
        StructureTemplatePool oldPool = (StructureTemplatePool)BuiltinRegistries.f_123864_.m_7745_(pool);
        if (oldPool != null) {
            oldPool.f_210559_.add(Pair.of((Object)newPiece, (Object)weight));
            ObjectArrayList jigsawPieces = oldPool.f_210560_;
            for (int i = 0; i < weight; ++i) {
                jigsawPieces.add(newPiece);
            }
        }
    }
}

