/*
 * Decompiled with CFR 0.152.
 */
package forestry.cultivation.gui.widgets;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import forestry.api.core.tooltips.ToolTip;
import forestry.api.farming.HorizontalDirection;
import forestry.core.gui.widgets.ItemStackWidget;
import forestry.core.gui.widgets.WidgetManager;
import forestry.core.render.ColourProperties;
import forestry.cultivation.inventory.InventoryPlanter;
import javax.annotation.Nullable;
import net.minecraft.client.gui.Font;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class GhostItemStackWidget
extends ItemStackWidget {
    private final Slot slot;

    public GhostItemStackWidget(WidgetManager widgetManager, int xPos, int yPos, ItemStack itemStack, Slot slot) {
        super(widgetManager, xPos, yPos, itemStack);
        this.slot = slot;
    }

    @Override
    public void draw(PoseStack transform, int startX, int startY) {
        if (!this.slot.m_6657_()) {
            super.draw(transform, startX, startY);
        }
        RenderSystem.m_69465_();
        RenderSystem.m_69478_();
        Component directionString = this.getDirectionString();
        if (directionString != null) {
            Font fontRenderer = this.manager.minecraft.f_91062_;
            fontRenderer.m_92763_(transform, directionString, (float)(this.xPos + startX + 5), (float)(this.yPos + startY + 4), ColourProperties.INSTANCE.get("gui.screen"));
        }
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.manager.gui.textureFile);
        this.manager.gui.m_93228_(transform, this.xPos + startX, this.yPos + startY, 206, 0, 16, 16);
        RenderSystem.m_69461_();
        RenderSystem.m_69482_();
    }

    @Nullable
    private Component getDirectionString() {
        if (this.slot.getSlotIndex() >= InventoryPlanter.CONFIG.productionStart || this.slot.getSlotIndex() < InventoryPlanter.CONFIG.productionStart + InventoryPlanter.CONFIG.productionCount) {
            return null;
        }
        int index = this.slot.getSlotIndex() % 4;
        Direction direction = HorizontalDirection.VALUES.get(index);
        String directionString = direction.m_7912_();
        return Component.m_237115_((String)("for.gui.planter." + directionString));
    }

    @Override
    @Nullable
    public ToolTip getToolTip(int mouseX, int mouseY) {
        return null;
    }
}

