/*
 * Decompiled with CFR 0.152.
 */
package forestry.cultivation.tiles;

import com.google.common.base.Preconditions;
import forestry.api.IForestryApi;
import forestry.api.climate.IClimateProvider;
import forestry.api.core.HumidityType;
import forestry.api.core.TemperatureType;
import forestry.api.farming.IFarmLogic;
import forestry.api.farming.IFarmType;
import forestry.api.farming.IFarmable;
import forestry.core.config.ForestryConfig;
import forestry.core.fluids.ITankManager;
import forestry.core.network.IStreamableGui;
import forestry.core.owner.IOwnedTile;
import forestry.core.owner.IOwnerHandler;
import forestry.core.owner.OwnerHandler;
import forestry.core.tiles.ILiquidTankTile;
import forestry.core.tiles.TilePowered;
import forestry.core.utils.PlayerUtil;
import forestry.cultivation.IFarmHousingInternal;
import forestry.cultivation.blocks.BlockPlanter;
import forestry.cultivation.blocks.BlockTypePlanter;
import forestry.cultivation.gui.ContainerPlanter;
import forestry.cultivation.inventory.InventoryPlanter;
import forestry.farming.FarmHelper;
import forestry.farming.FarmManager;
import forestry.farming.FarmTarget;
import forestry.farming.gui.IFarmLedgerDelegate;
import forestry.farming.multiblock.IFarmInventoryInternal;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public abstract class TilePlanter
extends TilePowered
implements IFarmHousingInternal,
IClimateProvider,
ILiquidTankTile,
IOwnedTile,
IStreamableGui {
    private final InventoryPlanter inventory;
    private final OwnerHandler ownerHandler = new OwnerHandler();
    private final FarmManager manager;
    private BlockPlanter.Mode mode;
    private final IFarmType properties;
    @Nullable
    private IFarmLogic logic;
    @Nullable
    private Vec3i offset;
    @Nullable
    private Vec3i area;

    protected TilePlanter(BlockEntityType type, BlockPos pos, BlockState state, ResourceLocation farmTypeId) {
        super(type, pos, state, 150, 1500);
        this.properties = (IFarmType)Preconditions.checkNotNull((Object)IForestryApi.INSTANCE.getFarmingManager().getFarmType(farmTypeId));
        this.mode = BlockPlanter.Mode.MANAGED;
        this.inventory = new InventoryPlanter(this);
        this.setInternalInventory(this.inventory);
        this.manager = new FarmManager(this);
        this.setEnergyPerWorkCycle(10);
        this.setTicksPerWorkCycle(2);
    }

    public void setManual(BlockPlanter.Mode mode) {
        this.mode = mode;
        this.logic = this.properties.getLogic(this.mode == BlockPlanter.Mode.MANUAL);
    }

    @Override
    public Component m_5446_() {
        String name = this.getBlockType(BlockTypePlanter.ARBORETUM).m_7912_();
        return Component.m_237110_((String)("block.forestry.planter." + this.mode.m_7912_()), (Object[])new Object[]{Component.m_237115_((String)("block.forestry." + name))});
    }

    @Override
    public boolean hasWork() {
        return true;
    }

    @Override
    public void serverTick(Level level, BlockPos pos, BlockState state) {
        super.serverTick(level, pos, state);
        this.manager.getHydrationManager().updateServer();
        if (this.updateOnInterval(20)) {
            this.inventory.drainCan(this.manager.getTankManager());
        }
    }

    @Override
    protected boolean workCycle() {
        this.manager.doWork();
        return false;
    }

    @Override
    public void m_183515_(CompoundTag data) {
        super.m_183515_(data);
        this.manager.write(data);
        this.ownerHandler.write(data);
        data.m_128405_("mode", this.mode.ordinal());
    }

    @Override
    public void m_142466_(CompoundTag data) {
        super.m_142466_(data);
        this.manager.read(data);
        this.ownerHandler.read(data);
        this.setManual(BlockPlanter.Mode.values()[data.m_128451_("mode")]);
    }

    @Override
    public void writeGuiData(FriendlyByteBuf data) {
        super.writeGuiData(data);
        this.manager.writeData(data);
    }

    @Override
    public void readGuiData(FriendlyByteBuf data) {
        super.readGuiData(data);
        this.manager.readData(data);
    }

    @Override
    public void setUpFarmlandTargets(Map<Direction, List<FarmTarget>> targets) {
        BlockPos targetStart = this.getCoords();
        BlockPos minPos = this.f_58858_;
        BlockPos maxPos = this.f_58858_;
        int size = 1;
        int extend = (Integer)ForestryConfig.SERVER.legacyFarmsPlanterRings.get();
        if (((Boolean)ForestryConfig.SERVER.legacyFarmsUseRings.get()).booleanValue()) {
            int ringSize = (Integer)ForestryConfig.SERVER.legacyFarmsRingSize.get();
            minPos = this.f_58858_.m_7918_(-ringSize, 0, -ringSize);
            maxPos = this.f_58858_.m_7918_(ringSize, 0, ringSize);
            size = 1 + ringSize * 2;
            --extend;
        }
        FarmHelper.createTargets(this.f_58857_, this, targets, targetStart, extend, size, size, minPos, maxPos);
        FarmHelper.setExtents(this.f_58857_, this, targets);
    }

    @Override
    public BlockPos getCoords() {
        return this.f_58858_;
    }

    @Override
    public BlockPos getTopCoord() {
        return this.f_58858_;
    }

    @Override
    public Vec3i getArea() {
        if (this.area == null) {
            int basisArea = 5;
            if (((Boolean)ForestryConfig.SERVER.legacyFarmsUseRings.get()).booleanValue()) {
                basisArea = basisArea + 1 + (Integer)ForestryConfig.SERVER.legacyFarmsRingSize.get() * 2;
            }
            this.area = new Vec3i(basisArea + (Integer)ForestryConfig.SERVER.legacyFarmsPlanterRings.get(), 13, basisArea + (Integer)ForestryConfig.SERVER.legacyFarmsPlanterRings.get());
        }
        return this.area;
    }

    @Override
    public Vec3i getOffset() {
        if (this.offset == null) {
            Vec3i area = this.getArea();
            this.offset = new Vec3i(-area.m_123341_() / 2, -2, -area.m_123343_() / 2);
        }
        return this.offset;
    }

    @Override
    public boolean doWork() {
        return false;
    }

    @Override
    public boolean hasLiquid(FluidStack liquid) {
        FluidStack drained = this.manager.getResourceTank().drainInternal(liquid, IFluidHandler.FluidAction.SIMULATE);
        return liquid.isFluidStackIdentical(drained);
    }

    @Override
    public void removeLiquid(FluidStack liquid) {
        this.manager.getResourceTank().drain(liquid.getAmount(), IFluidHandler.FluidAction.EXECUTE);
    }

    @Override
    public IOwnerHandler getOwnerHandler() {
        return this.ownerHandler;
    }

    @Override
    public boolean plantGermling(IFarmable farmable, Level world, BlockPos pos, Direction direction) {
        Player player = PlayerUtil.getFakePlayer(world, this.getOwnerHandler().getOwner());
        return player != null && this.inventory.plantGermling(farmable, player, pos, direction);
    }

    @Override
    public boolean isValidPlatform(Level world, BlockPos pos) {
        return pos.m_123342_() == this.m_58899_().m_123342_() - 2;
    }

    @Override
    public boolean isSquare() {
        return true;
    }

    @Override
    public boolean canPlantSoil(boolean manual) {
        return this.mode == BlockPlanter.Mode.MANAGED;
    }

    @Override
    public IFarmInventoryInternal getFarmInventory() {
        return this.inventory;
    }

    @Override
    public void addPendingProduct(ItemStack stack) {
        this.manager.addPendingProduct(stack);
    }

    @Override
    public void setFarmLogic(Direction direction, IFarmLogic logic) {
    }

    @Override
    public void resetFarmLogic(Direction direction) {
    }

    @Override
    public IFarmLogic getFarmLogic(Direction direction) {
        return this.getFarmLogic();
    }

    public IFarmLogic getFarmLogic() {
        return this.logic;
    }

    @Override
    public Collection<IFarmLogic> getFarmLogics() {
        return Collections.singleton(this.logic);
    }

    @Override
    public int getStoredFertilizerScaled(int scale) {
        return this.manager.getFertilizerManager().getStoredFertilizerScaled(this.inventory, scale);
    }

    @Override
    public void m_7651_() {
        super.m_7651_();
        this.manager.clearTargets();
    }

    @Override
    public CompoundTag m_5995_() {
        CompoundTag data = super.m_5995_();
        this.manager.write(data);
        return data;
    }

    public AbstractContainerMenu m_7208_(int windowId, Inventory inv, Player player) {
        return new ContainerPlanter(windowId, inv, this);
    }

    public IFarmLedgerDelegate getFarmLedgerDelegate() {
        return this.manager.getHydrationManager();
    }

    @Override
    public TemperatureType temperature() {
        return IForestryApi.INSTANCE.getClimateManager().getTemperature((Holder<Biome>)this.f_58857_.m_204166_(this.f_58858_));
    }

    @Override
    public HumidityType humidity() {
        return IForestryApi.INSTANCE.getClimateManager().getHumidity((Holder<Biome>)this.f_58857_.m_204166_(this.f_58858_));
    }

    @Override
    public ITankManager getTankManager() {
        return this.manager.getTankManager();
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (capability == ForgeCapabilities.FLUID_HANDLER) {
            return LazyOptional.of(this::getTankManager).cast();
        }
        return super.getCapability(capability, facing);
    }

    public abstract List<ItemStack> createGermlingStacks();

    public abstract List<ItemStack> createResourceStacks();

    public abstract List<ItemStack> createProductionStacks();

    @Override
    public BlockPos getFarmCorner(Direction direction) {
        return this.f_58858_.m_6625_(2);
    }

    @Override
    public int getExtents(Direction direction, BlockPos pos) {
        return this.manager.getExtents(direction, pos);
    }

    @Override
    public void setExtents(Direction direction, BlockPos pos, int extend) {
        this.manager.setExtents(direction, pos, extend);
    }

    @Override
    public void cleanExtents(Direction direction) {
        this.manager.cleanExtents(direction);
    }
}

